/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings;

import dev.denwav.hypo.mappings.ClassMappingsChange;
import dev.denwav.hypo.mappings.MappingsChange;
import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.model.HypoModelUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.cadixdev.lorenz.MappingSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeRegistry {
    @NotNull
    private final ConcurrentHashMap<MemberReference, List<MappingsChange>> changes = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, List<ClassMappingsChange>> classChanges = new ConcurrentHashMap();
    @NotNull
    private final MappingSet mappings;
    @Nullable
    private String currentContributorName = null;

    public ChangeRegistry(@NotNull MappingSet mappings) {
        this.mappings = mappings;
    }

    public void submitChange(@NotNull MappingsChange change) {
        this.changes.computeIfAbsent(change.target(), k -> Collections.synchronizedList(new ArrayList())).add(change);
    }

    public void submitChange(@NotNull ClassMappingsChange change) {
        this.classChanges.computeIfAbsent(change.targetClass(), k -> Collections.synchronizedList(new ArrayList())).add(change);
    }

    public void setCurrentContributorName(@Nullable String currentContributorName) {
        this.currentContributorName = currentContributorName;
    }

    @NotNull
    public Map<MemberReference, List<MappingsChange>> getChanges() {
        return this.changes;
    }

    @NotNull
    public ConcurrentHashMap<String, List<ClassMappingsChange>> getClassChanges() {
        return this.classChanges;
    }

    @NotNull
    public MappingSet getMappings() {
        return this.mappings;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public MappingSet applyChanges(@NotNull MappingSet input) {
        List duplicates = this.changes.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).filter(e -> {
            List changes = (List)e.getValue();
            Class<?> clazz = null;
            for (MappingsChange change : changes) {
                Class<?> changeClazz = change.getClass();
                if (clazz == null) {
                    clazz = changeClazz;
                }
                if (clazz != changeClazz) {
                    return true;
                }
                if (change instanceof MergeableMappingsChange) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            String dupes = duplicates.stream().map(e -> "\t" + String.valueOf(e.getKey()) + "\n" + ((List)e.getValue()).stream().map(r -> "\t\t" + String.valueOf(r)).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Multiple changes registered (via " + this.currentContributorName + " contributor) for the following member mappings:\n" + dupes);
        }
        ArrayList<CallSite> failures = null;
        MappingSet result = input.copy();
        for (List<MappingsChange> changes : this.changes.values()) {
            MappingsChange change = changes.get(0);
            if (changes.size() == 1) {
                change.applyChange(result);
                continue;
            }
            if (change instanceof MergeableMappingsChange) {
                boolean shouldApply = true;
                for (int i = 1; i < changes.size(); ++i) {
                    MappingsChange nextChange = changes.get(i);
                    if (nextChange == null) continue;
                    MergeResult<MergeableMappingsChange> mergeResult = ((MergeableMappingsChange)change).mergeWith((MergeableMappingsChange)HypoModelUtil.cast(nextChange));
                    if (mergeResult.isFailure()) {
                        if (failures == null) {
                            failures = new ArrayList<CallSite>();
                        }
                        failures.add((CallSite)((Object)("\tCannot merge changes: " + mergeResult.getErrorMessage() + "\n\t\t" + String.valueOf(change) + "\n\t\t" + String.valueOf(nextChange))));
                        shouldApply = false;
                        continue;
                    }
                    if (mergeResult.isSuccess()) {
                        change = mergeResult.getMerged();
                        continue;
                    }
                    throw new IllegalStateException("Merge result is somehow neither success nor failure: " + String.valueOf(mergeResult));
                }
                if (!shouldApply) continue;
                change.applyChange(result);
                continue;
            }
            throw new IllegalStateException("Cannot handle multiple non-mergeable changes: " + String.valueOf(changes));
        }
        if (failures != null && !failures.isEmpty()) {
            throw new IllegalStateException("Failed to apply mapping set changes from " + this.currentContributorName + " contributor:\n" + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)failures));
        }
        List multiClassChanges = this.classChanges.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).collect(Collectors.toList());
        if (!multiClassChanges.isEmpty()) {
            String dupes = multiClassChanges.stream().map(e -> "\t" + (String)e.getKey() + "\n" + ((List)e.getValue()).stream().map(r -> "\t\t" + String.valueOf(r)).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Multiple class changes registered (via " + this.currentContributorName + " contributor):\n" + dupes);
        }
        for (List<ClassMappingsChange> changes : this.classChanges.values()) {
            if (changes.isEmpty()) continue;
            changes.get(0).applyChange(result);
        }
        return result;
    }

    public void clear() {
        this.changes.clear();
        this.classChanges.clear();
    }
}

