/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.hydrate.generic;

import dev.denwav.hypo.model.data.ConstructorData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class SuperCall {
    @NotNull
    private final ConstructorData thisConstructor;
    @NotNull
    private final ConstructorData superConstructor;
    @NotNull
    private final @NotNull List<@NotNull SuperCallParameter> params;

    public SuperCall(@NotNull ConstructorData thisConstructor, @NotNull ConstructorData superConstructor, @NotNull @NotNull List<@NotNull SuperCallParameter> params) {
        this.thisConstructor = thisConstructor;
        this.superConstructor = superConstructor;
        this.params = params;
    }

    @NotNull
    public ConstructorData getThisConstructor() {
        return this.thisConstructor;
    }

    @NotNull
    public ConstructorData getSuperConstructor() {
        return this.superConstructor;
    }

    @NotNull
    public @NotNull List<@NotNull SuperCallParameter> getParams() {
        return this.params;
    }

    @Contract(value="_ -> new")
    @NotNull
    public SuperCall chain(@NotNull SuperCall that) {
        ArrayList<SuperCallParameter> newParams = new ArrayList<SuperCallParameter>();
        for (SuperCallParameter thisParam : this.params) {
            for (SuperCallParameter thatParam : that.params) {
                if (thisParam.getThisIndex() != thatParam.getSuperIndex()) continue;
                newParams.add(new SuperCallParameter(thatParam.getThisIndex(), thisParam.getSuperIndex()));
            }
        }
        return new SuperCall(that.getThisConstructor(), this.getSuperConstructor(), newParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuperCall)) {
            return false;
        }
        SuperCall superCall = (SuperCall)o;
        return this.thisConstructor.equals(superCall.thisConstructor) && this.superConstructor.equals(superCall.superConstructor) && this.params.equals(superCall.params);
    }

    public int hashCode() {
        return Objects.hash(this.thisConstructor, this.superConstructor, this.params);
    }

    public String toString() {
        return "SuperCall{thisConstructor=" + String.valueOf(this.thisConstructor) + ", superConstructor=" + String.valueOf(this.superConstructor) + ", params=" + String.valueOf(this.params) + "}";
    }

    public static final class SuperCallParameter {
        private final int thisIndex;
        private final int superIndex;

        public SuperCallParameter(int thisIndex, int superIndex) {
            this.thisIndex = thisIndex;
            this.superIndex = superIndex;
        }

        public int getThisIndex() {
            return this.thisIndex;
        }

        public int getSuperIndex() {
            return this.superIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SuperCallParameter)) {
                return false;
            }
            SuperCallParameter that = (SuperCallParameter)o;
            return this.thisIndex == that.thisIndex && this.superIndex == that.superIndex;
        }

        public int hashCode() {
            return Objects.hash(this.thisIndex, this.superIndex);
        }

        public String toString() {
            return "SuperCallParameter{thisIndex=" + this.thisIndex + ", superIndex=" + this.superIndex + "}";
        }
    }
}

