/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm.hydrate;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.asm.AsmConstructorData;
import dev.denwav.hypo.asm.hydrate.Constant;
import dev.denwav.hypo.asm.hydrate.FieldAccess;
import dev.denwav.hypo.asm.hydrate.MethodCall;
import dev.denwav.hypo.asm.hydrate.MethodCallArgument;
import dev.denwav.hypo.asm.hydrate.NewArray;
import dev.denwav.hypo.asm.hydrate.NewCall;
import dev.denwav.hypo.asm.hydrate.Variable;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.HydrationProvider;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.SuperCall;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ConstructorData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperConstructorHydrator
implements HydrationProvider<AsmConstructorData> {
    private static final Logger logger = LoggerFactory.getLogger(SuperConstructorHydrator.class);

    private SuperConstructorHydrator() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static SuperConstructorHydrator create() {
        return new SuperConstructorHydrator();
    }

    @Override
    public List<HypoKey<?>> provides() {
        return List.of(HypoHydration.SUPER_CALL_TARGET, HypoHydration.SUPER_CALLER_SOURCES);
    }

    @Override
    @NotNull
    public Class<? extends AsmConstructorData> target() {
        return AsmConstructorData.class;
    }

    @Override
    public void hydrate(@NotNull AsmConstructorData data, @NotNull HypoContext context) throws IOException {
        try {
            this.hydrate0(data);
        }
        catch (IllegalStateException e) {
            logger.debug("Failed to determine super constructor linking for {}#{}{}: {}", data.parentClass().name(), data.name(), data.descriptorText(), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hydrate0(@NotNull AsmConstructorData data) throws IOException {
        List superCallers;
        ClassData targetClass;
        MethodCall superCall = SuperConstructorHydrator.buildSuperCall(data);
        if (superCall == null) {
            return;
        }
        AsmClassData thisClass = data.parentClass();
        String owner = superCall.owner;
        String desc = superCall.desc;
        if (owner == null || desc == null) {
            throw new IllegalStateException("Could not determine owner or desc of super method");
        }
        String normalizedOwner = HypoModelUtil.normalizedClassName(owner);
        ClassData superClass = thisClass.superClass();
        if (thisClass.name().equals(normalizedOwner)) {
            targetClass = thisClass;
        } else if (superClass != null && superClass.name().equals(normalizedOwner)) {
            targetClass = superClass;
        } else {
            if (superClass == null) {
                throw new IllegalStateException("Could not find owner of super method");
            }
            throw new IllegalStateException("Could not determine owner of super method");
        }
        MethodData targetMethod = targetClass.method("<init>", MethodDescriptor.parseDescriptor(desc));
        if (!(targetMethod instanceof ConstructorData)) {
            throw new IllegalStateException("Target constructor is not an instance of " + ConstructorData.class.getName());
        }
        ConstructorData targetConstructor = (ConstructorData)targetMethod;
        ArrayList<SuperCall.SuperCallParameter> superCallParams = new ArrayList<SuperCall.SuperCallParameter>();
        SuperCall superCallData = new SuperCall(data, targetConstructor, superCallParams);
        data.store(HypoHydration.SUPER_CALL_TARGET, superCallData);
        List list = superCallers = targetConstructor.compute(HypoHydration.SUPER_CALLER_SOURCES, ArrayList::new);
        synchronized (list) {
            superCallers.add(superCallData);
        }
        int[] thisParamIndices = SuperConstructorHydrator.buildParamIndexMapping(data);
        int[] targetParamIndices = SuperConstructorHydrator.buildParamIndexMapping(targetConstructor);
        int index = -1;
        for (MethodCallArgument arg : superCall.args) {
            int varIndex;
            Variable varArgument;
            ++index;
            boolean simpleArg = false;
            if (arg instanceof Variable) {
                varArgument = (Variable)arg;
                simpleArg = true;
            } else {
                if (!(arg instanceof MethodCall)) continue;
                MethodCall subCall = (MethodCall)arg;
                if (subCall.args.size() != 1 && !(subCall.receiver instanceof Variable)) continue;
                if (subCall.receiver instanceof Variable) {
                    varArgument = (Variable)subCall.receiver;
                } else {
                    MethodCallArgument first = subCall.args.getFirst();
                    if (!(first instanceof Variable)) continue;
                    varArgument = (Variable)first;
                }
            }
            if ((varIndex = varArgument.index) > thisParamIndices[thisParamIndices.length - 1]) continue;
            if (simpleArg) {
                superCallParams.removeIf(s2 -> s2.getThisIndex() == varIndex);
            } else {
                boolean anyExist = false;
                for (SuperCall.SuperCallParameter superCallParam : superCallParams) {
                    if (superCallParam.getThisIndex() != varIndex) continue;
                    anyExist = true;
                    break;
                }
                if (anyExist) continue;
            }
            superCallParams.add(new SuperCall.SuperCallParameter(varIndex, targetParamIndices[index]));
        }
    }

    @Nullable
    private static MethodCall buildSuperCall(@NotNull AsmConstructorData data) {
        MethodCall superCall = new MethodCall();
        block23: for (AbstractInsnNode insn = data.getNode().instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn instanceof LabelNode || insn instanceof LineNumberNode || insn instanceof FrameNode) continue;
            int opcode = insn.getOpcode();
            switch (opcode) {
                case 186: {
                    InvokeDynamicInsnNode dynNode = (InvokeDynamicInsnNode)insn;
                    int dynArgCount = Type.getArgumentTypes(dynNode.desc).length;
                    superCall.collapseInvoke(dynArgCount, true, null, dynNode.desc);
                    continue block23;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode methodNode = (MethodInsnNode)insn;
                    int argCount = Type.getArgumentTypes(methodNode.desc).length;
                    boolean isStatic = opcode == 184;
                    superCall.collapseInvoke(argCount, isStatic, methodNode.owner, methodNode.desc);
                    if (superCall.receiver == null) continue block23;
                    if (opcode == 183) break block23;
                    throw new IllegalStateException("Super call collapsed on non-INVOKESPECIAL instruction: " + opcode);
                }
                case 187: {
                    superCall.args.add(new NewCall(((TypeInsnNode)insn).desc));
                    continue block23;
                }
                case 188: 
                case 189: {
                    superCall.args.removeLast();
                    superCall.args.addLast(NewArray.INSTANCE);
                    continue block23;
                }
                case 89: {
                    MethodCallArgument dupStack = superCall.args.peekLast();
                    if (dupStack == null) continue block23;
                    superCall.args.addLast(dupStack);
                    continue block23;
                }
                case 88: {
                    superCall.args.removeLast();
                }
                case 87: {
                    superCall.args.removeLast();
                    continue block23;
                }
                case 95: {
                    MethodCallArgument swap1 = superCall.args.removeLast();
                    MethodCallArgument swap2 = superCall.args.removeLast();
                    superCall.args.addLast(swap1);
                    superCall.args.addLast(swap2);
                    continue block23;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    superCall.args.add(new Variable(((VarInsnNode)insn).var));
                    continue block23;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    superCall.args.removeLast();
                    superCall.args.removeLast();
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    superCall.args.removeLast();
                    continue block23;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 178: {
                    superCall.args.add(Constant.INSTANCE);
                    continue block23;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    superCall.args.removeLast();
                    superCall.args.removeLast();
                    superCall.args.addLast(Constant.INSTANCE);
                    continue block23;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 192: 
                case 193: {
                    continue block23;
                }
                case 181: {
                    superCall.args.removeLast();
                    superCall.args.removeLast();
                    continue block23;
                }
                case 180: {
                    FieldAccess fieldAccess = new FieldAccess(superCall.args.removeLast());
                    superCall.args.addLast(fieldAccess);
                    continue block23;
                }
                case 190: {
                    superCall.args.removeLast();
                    superCall.args.addLast(Constant.INSTANCE);
                    continue block23;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    superCall.args.removeLast();
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    superCall.args.removeLast();
                    continue block23;
                }
                case 167: {
                    insn = ((JumpInsnNode)insn).label;
                    continue block23;
                }
                case 168: 
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    return null;
                }
                default: {
                    throw new IllegalStateException("Instruction not expected, probably a more complex case: " + insn.getOpcode());
                }
            }
        }
        if (superCall.receiver == null) {
            return null;
        }
        MethodCallArgument receiver = superCall.receiver;
        if (!(receiver instanceof Variable) || ((Variable)receiver).index != 0) {
            throw new IllegalStateException("Receiver for super call is not `this`");
        }
        return superCall;
    }

    private static int @NotNull [] buildParamIndexMapping(@NotNull MethodData data) throws IOException {
        List<@NotNull JvmType> targetParams = data.params();
        int[] outputParamIndices = new int[targetParams.size()];
        int currentIndex = 0;
        int currentTargetIndex = 1;
        if (data.parentClass().outerClass() != null && !data.parentClass().isStaticInnerClass()) {
            ++currentTargetIndex;
        }
        for (JvmType paramType : targetParams) {
            outputParamIndices[currentIndex] = currentTargetIndex++;
            ++currentIndex;
            if (paramType != PrimitiveType.LONG && paramType != PrimitiveType.DOUBLE) continue;
            ++currentTargetIndex;
        }
        return outputParamIndices;
    }
}

