/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm.hydrate;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.HydrationProvider;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BridgeMethodHydrator
implements HydrationProvider<AsmMethodData> {
    private BridgeMethodHydrator() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static BridgeMethodHydrator create() {
        return new BridgeMethodHydrator();
    }

    @Override
    @NotNull
    public Class<? extends AsmMethodData> target() {
        return AsmMethodData.class;
    }

    @Override
    public List<HypoKey<?>> provides() {
        return List.of(HypoHydration.SYNTHETIC_SOURCES, HypoHydration.SYNTHETIC_TARGET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hydrate(@NotNull AsmMethodData data, @NotNull HypoContext context) throws IOException {
        Set sources;
        ClassData owner;
        if (!data.isSynthetic() || data.name().indexOf(36) != -1) {
            return;
        }
        State state = State.IN_PARAMS;
        int nextLvt = 0;
        MethodInsnNode invokeInsn = null;
        for (AbstractInsnNode insn : data.getNode().instructions) {
            if (insn instanceof LabelNode || insn instanceof LineNumberNode || insn instanceof TypeInsnNode) continue;
            if (!(state != State.IN_PARAMS || insn instanceof VarInsnNode && ((VarInsnNode)insn).var == nextLvt)) {
                state = State.INVOKE;
            }
            int opcode = insn.getOpcode();
            switch (state.ordinal()) {
                case 0: {
                    ++nextLvt;
                    if (opcode != 22 && opcode != 24) break;
                    ++nextLvt;
                    break;
                }
                case 1: {
                    if (opcode != 182 && opcode != 185 && opcode != 183) {
                        return;
                    }
                    invokeInsn = (MethodInsnNode)insn;
                    state = State.RETURN;
                    break;
                }
                case 2: {
                    if (opcode < 172 || opcode > 177) {
                        return;
                    }
                    state = State.OTHER_INSN;
                    break;
                }
                case 3: {
                    return;
                }
            }
        }
        if (invokeInsn == null) {
            return;
        }
        @NotNull MethodInsnNode invoke = invokeInsn;
        if (invoke.name.indexOf(36) != -1) {
            return;
        }
        AsmClassData parent = data.parentClass();
        ClassData grandParent = parent.superClass();
        if (parent.name().equals(invoke.owner)) {
            owner = parent;
        } else if (grandParent != null && grandParent.name().equals(invoke.owner)) {
            owner = grandParent;
        } else {
            return;
        }
        if (data.name().equals(invoke.name) && data.getNode().desc.equals(invoke.desc)) {
            return;
        }
        MethodDescriptor invokeDesc = MethodDescriptor.parseDescriptor(invoke.desc);
        if (data.params().size() != invokeDesc.getParams().size()) {
            return;
        }
        MethodData targetMethod = owner.method(invoke.name, invokeDesc);
        if (targetMethod == null) {
            return;
        }
        data.store(HypoHydration.SYNTHETIC_TARGET, targetMethod);
        BridgeMethodHydrator.setSynthSource(targetMethod, data);
        Set set = sources = targetMethod.compute(HypoHydration.SYNTHETIC_SOURCES, HashSet::new);
        synchronized (set) {
            sources.add(data);
        }
    }

    private static void setSynthSource(MethodData targetMethod, MethodData data) {
        targetMethod.store(HypoHydration.SYNTHETIC_SOURCE, data);
    }

    static enum State {
        IN_PARAMS,
        INVOKE,
        RETURN,
        OTHER_INSN;

    }
}

