/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.impl.UnpickValue;
import daomephsta.unpick.impl.representations.ReplacementSet;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;

public interface ReplacementInstructionGenerator
extends IReplacementGenerator {
    public boolean canReplace(Context var1);

    public void generateReplacements(Context var1);

    @Override
    default public void apply(IReplacementGenerator.IContext context) {
        Context contextImpl = (Context)context;
        if (this.canReplace(contextImpl)) {
            this.generateReplacements(contextImpl);
        }
    }

    public static class Context
    implements IReplacementGenerator.IContext {
        private final IClassResolver classResolver;
        private final IConstantResolver constantResolver;
        private final IInheritanceChecker inheritanceChecker;
        private final ReplacementSet replacementSet;
        private final ClassNode containingClass;
        private final MethodNode containingMethod;
        private final AbstractInsnNode target;
        private final Frame<UnpickValue>[] frames;
        private final Logger logger;

        public Context(IClassResolver classResolver, IConstantResolver constantResolver, IInheritanceChecker inheritanceChecker, ReplacementSet replacementSet, ClassNode containingClass, MethodNode containingMethod, AbstractInsnNode target, Frame<UnpickValue>[] frames, Logger logger) {
            this.classResolver = classResolver;
            this.constantResolver = constantResolver;
            this.inheritanceChecker = inheritanceChecker;
            this.replacementSet = replacementSet;
            this.containingClass = containingClass;
            this.containingMethod = containingMethod;
            this.target = target;
            this.frames = frames;
            this.logger = logger;
        }

        @Override
        public IClassResolver getClassResolver() {
            return this.classResolver;
        }

        @Override
        public IConstantResolver getConstantResolver() {
            return this.constantResolver;
        }

        @Override
        public IInheritanceChecker getInheritanceChecker() {
            return this.inheritanceChecker;
        }

        @Override
        public ClassNode getContainingClass() {
            return this.containingClass;
        }

        @Override
        public MethodNode getContainingMethod() {
            return this.containingMethod;
        }

        @Override
        public ReplacementSet getReplacementSet() {
            return this.replacementSet;
        }

        @Override
        public AbstractInsnNode getTarget() {
            return this.target;
        }

        @Override
        @Nullable
        public Frame<IReplacementGenerator.IDataflowValue> getDataflowFrame(AbstractInsnNode insn) {
            return this.frames[this.containingMethod.instructions.indexOf(insn)];
        }

        @Override
        public Logger getLogger() {
            return this.logger;
        }
    }
}

