/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.membercheckers;

import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.impl.Utils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ChainMemberChecker
implements IMemberChecker {
    private final IMemberChecker[] checkers;

    public ChainMemberChecker(IMemberChecker[] checkers) {
        this.checkers = checkers;
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getFields(String className) {
        for (IMemberChecker checker : this.checkers) {
            List<IMemberChecker.MemberInfo> fields = checker.getFields(className);
            if (fields == null) continue;
            return fields;
        }
        return null;
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getMethods(String className) {
        for (IMemberChecker checker : this.checkers) {
            List<IMemberChecker.MemberInfo> methods = checker.getMethods(className);
            if (methods == null) continue;
            return methods;
        }
        return null;
    }

    @Override
    @Nullable
    public IMemberChecker.MemberInfo getField(String className, String fieldName, String fieldDesc) {
        for (IMemberChecker checker : this.checkers) {
            IMemberChecker.MemberInfo field = checker.getField(className, fieldName, fieldDesc);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    @Override
    @Nullable
    public IMemberChecker.MemberInfo getMethod(String className, String methodName, String methodDesc) {
        for (IMemberChecker checker : this.checkers) {
            IMemberChecker.MemberInfo method = checker.getMethod(className, methodName, methodDesc);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Override
    @Nullable
    public IMemberChecker.ParameterInfo getParameter(String className, String methodName, String methodDesc, int parameterIndex) {
        for (IMemberChecker checker : this.checkers) {
            IMemberChecker.ParameterInfo parameter = checker.getParameter(className, methodName, methodDesc, parameterIndex);
            if (parameter == null) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public IMemberChecker chain(IMemberChecker ... others) {
        return new ChainMemberChecker(Utils.concat(this.checkers, others));
    }
}

