/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.membercheckers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;

public class BytecodeAnalysisMemberChecker
implements IMemberChecker {
    private static final List<AnnotationNode>[] EMPTY_ANNOTATION_LIST_ARRAY = new List[0];
    private final IClassResolver classResolver;
    private final ConcurrentMap<String, ClassInfo> classInfoCache = new ConcurrentHashMap<String, ClassInfo>();

    public BytecodeAnalysisMemberChecker(IClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getFields(String className) {
        ClassInfo classInfo = this.getClassInfo(className);
        return classInfo != null ? classInfo.fields : null;
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getMethods(String className) {
        ClassInfo classInfo = this.getClassInfo(className);
        return classInfo != null ? classInfo.methods : null;
    }

    @Override
    @Nullable
    public IMemberChecker.ParameterInfo getParameter(String className, String methodName, String methodDesc, int parameterIndex) {
        ClassInfo classInfo = this.getClassInfo(className);
        if (classInfo == null) {
            return null;
        }
        List<IMemberChecker.ParameterInfo> params = classInfo.parameters.get(methodName + methodDesc);
        return params != null && parameterIndex < params.size() ? params.get(parameterIndex) : null;
    }

    @Nullable
    private ClassInfo getClassInfo(String className) {
        return this.classInfoCache.computeIfAbsent(className, k -> {
            ClassNode node = this.classResolver.resolveClass((String)k);
            if (node == null) {
                return null;
            }
            ArrayList<IMemberChecker.MemberInfo> fields = new ArrayList<IMemberChecker.MemberInfo>();
            for (FieldNode field : node.fields) {
                fields.add(IMemberChecker.MemberInfo.create(field.access, field.name, field.desc).withAnnotations(BytecodeAnalysisMemberChecker.getAnnotations(field.visibleAnnotations, field.invisibleAnnotations)));
            }
            ArrayList<IMemberChecker.MemberInfo> methods = new ArrayList<IMemberChecker.MemberInfo>();
            HashMap<String, List<IMemberChecker.ParameterInfo>> parameters = new HashMap<String, List<IMemberChecker.ParameterInfo>>();
            for (MethodNode method : node.methods) {
                methods.add(IMemberChecker.MemberInfo.create(method.access, method.name, method.desc).withAnnotations(BytecodeAnalysisMemberChecker.getAnnotations(method.visibleAnnotations, method.invisibleAnnotations)));
                ArrayList<IMemberChecker.ParameterInfo> params = new ArrayList<IMemberChecker.ParameterInfo>();
                parameters.put(method.name + method.desc, params);
                List paramNodes = Objects.requireNonNullElse(method.parameters, List.of());
                List<AnnotationNode>[] visibleParamAnnotations = Objects.requireNonNullElse(method.visibleParameterAnnotations, EMPTY_ANNOTATION_LIST_ARRAY);
                List<AnnotationNode>[] invisibleParamAnnotations = Objects.requireNonNullElse(method.invisibleParameterAnnotations, EMPTY_ANNOTATION_LIST_ARRAY);
                int realParamIndex = 0;
                int nonSyntheticParamIndex = 0;
                while (nonSyntheticParamIndex < Math.max(visibleParamAnnotations.length, invisibleParamAnnotations.length)) {
                    while (realParamIndex < paramNodes.size() && (((ParameterNode)paramNodes.get((int)realParamIndex)).access & 0x1000) != 0) {
                        params.add(IMemberChecker.ParameterInfo.create(0));
                        ++realParamIndex;
                    }
                    int access = realParamIndex < paramNodes.size() ? ((ParameterNode)paramNodes.get((int)realParamIndex)).access : 0;
                    List<AnnotationNode> visibleAnnotations = nonSyntheticParamIndex < visibleParamAnnotations.length ? visibleParamAnnotations[nonSyntheticParamIndex] : null;
                    List<AnnotationNode> invisibleAnnotations = nonSyntheticParamIndex < invisibleParamAnnotations.length ? invisibleParamAnnotations[nonSyntheticParamIndex] : null;
                    params.add(IMemberChecker.ParameterInfo.create(access).withAnnotations(BytecodeAnalysisMemberChecker.getAnnotations(visibleAnnotations, invisibleAnnotations)));
                    ++nonSyntheticParamIndex;
                    ++realParamIndex;
                }
            }
            return new ClassInfo(fields, methods, parameters);
        });
    }

    private static List<String> getAnnotations(@Nullable List<AnnotationNode> visibleAnnotations, @Nullable List<AnnotationNode> invisibleAnnotations) {
        ArrayList<String> annotations = new ArrayList<String>();
        if (visibleAnnotations != null) {
            for (AnnotationNode annotation : visibleAnnotations) {
                annotations.add(Type.getType(annotation.desc).getClassName());
            }
        }
        if (invisibleAnnotations != null) {
            for (AnnotationNode annotation : invisibleAnnotations) {
                annotations.add(Type.getType(annotation.desc).getClassName());
            }
        }
        return annotations;
    }

    private record ClassInfo(List<IMemberChecker.MemberInfo> fields, List<IMemberChecker.MemberInfo> methods, Map<String, List<IMemberChecker.ParameterInfo>> parameters) {
    }
}

