/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.inheritancecheckers;

import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import org.jetbrains.annotations.Nullable;

public class ClasspathInheritanceChecker
implements IInheritanceChecker {
    @Nullable
    private final ClassLoader classLoader;

    public ClasspathInheritanceChecker(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public IInheritanceChecker.ClassInfo getClassInfo(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className.replace('/', '.'), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        Class superclass = clazz.isInterface() ? Object.class : clazz.getSuperclass();
        String superclassName = superclass == null ? null : superclass.getName().replace('.', '/');
        Class<?>[] interfaces = clazz.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName().replace('.', '/');
        }
        return new IInheritanceChecker.ClassInfo(superclassName, interfaceNames, clazz.isInterface());
    }
}

