/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.inheritancecheckers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class BytecodeAnalysisInheritanceChecker
implements IInheritanceChecker {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final IClassResolver classResolver;
    private final ConcurrentMap<String, IInheritanceChecker.ClassInfo> classInfoCache = new ConcurrentHashMap<String, IInheritanceChecker.ClassInfo>();

    public BytecodeAnalysisInheritanceChecker(IClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    @Nullable
    public IInheritanceChecker.ClassInfo getClassInfo(String className) {
        return this.classInfoCache.computeIfAbsent(className, name -> {
            ClassNode node = this.classResolver.resolveClass((String)name);
            if (node == null) {
                return null;
            }
            return new IInheritanceChecker.ClassInfo(node.superName, node.interfaces == null ? EMPTY_ARRAY : node.interfaces.toArray(new String[0]), (node.access & 0x200) != 0);
        });
    }
}

