/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantresolvers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.impl.AbstractInsnNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class BytecodeAnalysisConstantResolver
implements IConstantResolver {
    static final Set<Type> VALID_CONSTANT_TYPES = Set.of(Type.BYTE_TYPE, Type.SHORT_TYPE, Type.CHAR_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.getObjectType("java/lang/String"), Type.getObjectType("java/lang/Class"));
    private final ConcurrentMap<String, Map<String, IConstantResolver.ResolvedConstant>> constantDataCache = new ConcurrentHashMap<String, Map<String, IConstantResolver.ResolvedConstant>>();
    private final IClassResolver classResolver;

    public BytecodeAnalysisConstantResolver(IClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public IConstantResolver.ResolvedConstant resolveConstant(String owner, String name) {
        Map resolvedConstants = this.constantDataCache.computeIfAbsent(owner, this::extractConstants);
        return resolvedConstants == null ? null : (IConstantResolver.ResolvedConstant)resolvedConstants.get(name);
    }

    @Override
    public Map<String, IConstantResolver.ResolvedConstant> getAllConstantsInClass(String owner) {
        Map resolvedConstants = this.constantDataCache.computeIfAbsent(owner, this::extractConstants);
        return resolvedConstants == null ? null : Collections.unmodifiableMap(resolvedConstants);
    }

    @Nullable
    protected Map<String, IConstantResolver.ResolvedConstant> extractConstants(String owner) {
        ClassNode node = this.classResolver.resolveClass(owner);
        if (node == null) {
            return null;
        }
        ResolvedConstantsBuilder builder = new ResolvedConstantsBuilder(owner);
        node.accept(builder);
        return builder.resolvedConstants;
    }

    private static class ResolvedConstantsBuilder
    extends ClassVisitor {
        private final String ownerClass;
        private final Map<String, IConstantResolver.ResolvedConstant> resolvedConstants = new HashMap<String, IConstantResolver.ResolvedConstant>();
        private final Map<String, Type> staticFieldsNeedingValue = new HashMap<String, Type>();
        private final Map<String, Type> nonStaticFieldsNeedingValue = new HashMap<String, Type>();
        private final List<MethodNode> constructors = new ArrayList<MethodNode>();
        @Nullable
        private MethodNode staticInitializer;

        ResolvedConstantsBuilder(String ownerClass) {
            super(589824);
            this.ownerClass = ownerClass;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            boolean isStatic;
            if ((access & 0x10) == 0) {
                return null;
            }
            Type fieldType = Type.getType(descriptor);
            if (!VALID_CONSTANT_TYPES.contains(fieldType)) {
                return null;
            }
            boolean bl = isStatic = (access & 8) != 0;
            if (value != null) {
                this.resolvedConstants.put(name, ResolvedConstantsBuilder.createResolvedConstant(fieldType, value, isStatic));
                return null;
            }
            if (isStatic) {
                this.staticFieldsNeedingValue.put(name, fieldType);
            } else {
                this.nonStaticFieldsNeedingValue.put(name, fieldType);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return switch (name) {
                case "<init>" -> {
                    MethodNode ctor = new MethodNode(access, name, descriptor, signature, exceptions);
                    this.constructors.add(ctor);
                    yield ctor;
                }
                case "<clinit>" -> this.staticInitializer = new MethodNode(access, name, descriptor, signature, exceptions);
                default -> null;
            };
        }

        @Override
        public void visitEnd() {
            if (!this.staticFieldsNeedingValue.isEmpty() && this.staticInitializer != null) {
                HashMap<String, @Nullable Object> staticFieldValues = new HashMap<String, Object>();
                for (AbstractInsnNode insn : this.staticInitializer.instructions) {
                    Type fieldType;
                    if (insn.getOpcode() != 179) continue;
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (!fieldInsn.owner.equals(this.ownerClass) || (fieldType = this.staticFieldsNeedingValue.get(fieldInsn.name)) == null || !fieldType.getDescriptor().equals(fieldInsn.desc)) continue;
                    AbstractInsnNode prevInsn = AbstractInsnNodes.previousInstruction(insn);
                    if (prevInsn == null || !AbstractInsnNodes.hasLiteralValue(prevInsn)) {
                        staticFieldValues.remove(fieldInsn.name);
                        this.staticFieldsNeedingValue.remove(fieldInsn.name);
                        continue;
                    }
                    Object value2 = AbstractInsnNodes.getLiteralValue(prevInsn);
                    if (staticFieldValues.containsKey(fieldInsn.name)) {
                        if (Objects.equals(staticFieldValues.get(fieldInsn.name), value2)) continue;
                        staticFieldValues.remove(fieldInsn.name);
                        this.staticFieldsNeedingValue.remove(fieldInsn.name);
                        continue;
                    }
                    staticFieldValues.put(fieldInsn.name, value2);
                }
                staticFieldValues.forEach((name, value) -> this.resolvedConstants.put((String)name, ResolvedConstantsBuilder.createResolvedConstant(this.staticFieldsNeedingValue.get(name), value, true)));
            }
            if (!this.nonStaticFieldsNeedingValue.isEmpty()) {
                HashMap<String, @Nullable Object> nonStaticFieldValues = new HashMap<String, Object>();
                for (MethodNode constructor : this.constructors) {
                    MethodInsnNode delegateConstructorCall = ResolvedConstantsBuilder.findDelegateConstructorCall(constructor.instructions);
                    if (delegateConstructorCall == null) continue;
                    HashSet<Object> unassignedFields = delegateConstructorCall.owner.equals(this.ownerClass) ? new HashSet() : new HashSet<String>(this.nonStaticFieldsNeedingValue.keySet());
                    for (AbstractInsnNode insn : constructor.instructions) {
                        Type fieldType;
                        if (insn.getOpcode() != 181) continue;
                        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                        if (!fieldInsn.owner.equals(this.ownerClass) || (fieldType = this.nonStaticFieldsNeedingValue.get(fieldInsn.name)) == null || !fieldType.getDescriptor().equals(fieldInsn.desc)) continue;
                        AbstractInsnNode prevInsn = AbstractInsnNodes.previousInstruction(insn);
                        if (prevInsn == null || !AbstractInsnNodes.hasLiteralValue(prevInsn)) {
                            nonStaticFieldValues.remove(fieldInsn.name);
                            this.nonStaticFieldsNeedingValue.remove(fieldInsn.name);
                            continue;
                        }
                        unassignedFields.remove(fieldInsn.name);
                        Object value3 = AbstractInsnNodes.getLiteralValue(prevInsn);
                        if (nonStaticFieldValues.containsKey(fieldInsn.name)) {
                            if (Objects.equals(nonStaticFieldValues.get(fieldInsn.name), value3)) continue;
                            nonStaticFieldValues.remove(fieldInsn.name);
                            this.nonStaticFieldsNeedingValue.remove(fieldInsn.name);
                            continue;
                        }
                        nonStaticFieldValues.put(fieldInsn.name, value3);
                    }
                    nonStaticFieldValues.keySet().removeAll(unassignedFields);
                    this.nonStaticFieldsNeedingValue.keySet().removeAll(unassignedFields);
                }
                nonStaticFieldValues.forEach((name, value) -> this.resolvedConstants.put((String)name, ResolvedConstantsBuilder.createResolvedConstant(this.nonStaticFieldsNeedingValue.get(name), value, false)));
            }
        }

        @Nullable
        private static MethodInsnNode findDelegateConstructorCall(InsnList instructions) {
            int newCalls = 0;
            for (AbstractInsnNode insn : instructions) {
                switch (insn.getOpcode()) {
                    case 187: {
                        ++newCalls;
                        break;
                    }
                    case 183: {
                        MethodInsnNode methodInsn = (MethodInsnNode)insn;
                        if (!"<init>".equals(methodInsn.name)) break;
                        if (newCalls == 0) {
                            return methodInsn;
                        }
                        --newCalls;
                    }
                }
            }
            return null;
        }

        private static IConstantResolver.ResolvedConstant createResolvedConstant(Type type, @Nullable Object value, boolean isStatic) {
            switch (type.getSort()) {
                case 3: {
                    if (!(value instanceof Number)) break;
                    Number number = (Number)value;
                    value = number.byteValue();
                    break;
                }
                case 4: {
                    if (!(value instanceof Number)) break;
                    Number number = (Number)value;
                    value = number.shortValue();
                    break;
                }
                case 2: {
                    if (!(value instanceof Number)) break;
                    Number number = (Number)value;
                    value = Character.valueOf((char)number.intValue());
                }
            }
            return new IConstantResolver.ResolvedConstant(type, value, isStatic);
        }
    }
}

