/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven.parser.v2;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.parser.v2.UnpickV2Reader;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.constantmappers.datadriven.data.Data;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public final class V2Parser
implements UnpickV2Reader.Visitor {
    private final Logger logger;
    private final boolean lenient;
    private final IConstantResolver constantResolver;
    private final Data data;
    private int lineNumber;

    private V2Parser(Logger logger, boolean lenient, IConstantResolver constantResolver, Data data) {
        this.logger = logger;
        this.lenient = lenient;
        this.constantResolver = constantResolver;
        this.data = data;
    }

    public static void parse(Logger logger, boolean lenient, Reader mappingSource, IConstantResolver constantResolver, Data data) throws IOException {
        try (UnpickV2Reader unpickDefinitions = new UnpickV2Reader(mappingSource);){
            unpickDefinitions.accept(new V2Parser(logger, lenient, constantResolver, data));
        }
    }

    public static DataType parseType(String descriptor, int lineNumber) {
        return switch (descriptor) {
            case "B" -> DataType.BYTE;
            case "C" -> DataType.CHAR;
            case "D" -> DataType.DOUBLE;
            case "F" -> DataType.FLOAT;
            case "I" -> DataType.INT;
            case "J" -> DataType.LONG;
            case "S" -> DataType.SHORT;
            case "Ljava/lang/String;" -> DataType.STRING;
            default -> throw new UnpickSyntaxException(lineNumber, "Invalid constant type " + descriptor);
        };
    }

    public static DataType widenGroupType(DataType groupType) {
        return switch (groupType) {
            case DataType.BYTE, DataType.SHORT, DataType.CHAR -> DataType.INT;
            default -> groupType;
        };
    }

    @Override
    public void visitLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void visitSimpleConstantDefinition(String groupId, String owner, String name, String value, String descriptor) {
        this.visitConstantDefinition(false, groupId, owner, name, descriptor);
    }

    @Override
    public void visitFlagConstantDefinition(String groupId, String owner, String name, String value, String descriptor) {
        this.visitConstantDefinition(true, groupId, owner, name, descriptor);
    }

    private void visitConstantDefinition(boolean flags, String groupId, String owner, String name, @Nullable String descriptor) {
        DataType dataType;
        if (descriptor != null) {
            dataType = V2Parser.parseType(descriptor, this.lineNumber);
        } else {
            IConstantResolver.ResolvedConstant constant = this.constantResolver.resolveConstant(owner, name);
            if (constant == null) {
                Utils.throwOrWarn(this.logger, this.lenient, () -> "Constant '" + owner + "." + name + "' not found");
                return;
            }
            dataType = V2Parser.parseType(constant.type().getDescriptor(), this.lineNumber);
        }
        DataType groupDataType = V2Parser.widenGroupType(dataType);
        GroupDefinition.Builder groupDefinition = GroupDefinition.Builder.named(groupDataType, groupId).constant(new FieldExpression(owner.replace('/', '.'), name, null, true));
        if (flags) {
            groupDefinition.flags();
        }
        this.data.visitGroupDefinition(groupDefinition.build());
    }

    @Override
    public UnpickV2Reader.TargetMethodDefinitionVisitor visitTargetMethodDefinition(String owner, String name, String descriptor) {
        return new TargetMethodParser(this.data, owner.replace('/', '.'), name, descriptor, () -> this.lineNumber);
    }

    private static class TargetMethodParser
    implements UnpickV2Reader.TargetMethodDefinitionVisitor {
        private final Data data;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final Map<Integer, String> parameterGroups = new HashMap<Integer, String>();
        @Nullable
        private String returnGroup;
        private final IntSupplier lineNumber;

        TargetMethodParser(Data data, String owner, String name, String descriptor, IntSupplier lineNumber) {
            this.data = data;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.lineNumber = lineNumber;
        }

        @Override
        public void visitParameterGroupDefinition(int parameterIndex, String group) {
            if (this.parameterGroups.put(parameterIndex, group) != null) {
                throw new UnpickSyntaxException(this.lineNumber.getAsInt(), "Duplicate parameter index " + parameterIndex);
            }
        }

        @Override
        public void visitReturnGroupDefinition(String group) {
            if (this.returnGroup != null) {
                throw new UnpickSyntaxException(this.lineNumber.getAsInt(), "Duplicate return group " + this.returnGroup);
            }
            this.returnGroup = group;
        }

        @Override
        public void endVisit() {
            this.data.visitTargetMethod(new TargetMethod(this.owner, this.name, this.descriptor, this.parameterGroups, this.returnGroup));
        }
    }
}

