/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven.parser;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.constantmappers.datadriven.data.Data;
import daomephsta.unpick.impl.constantmappers.datadriven.parser.v2.V2Parser;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class V1Parser {
    private static final Pattern WHITESPACE_SPLITTER = Pattern.compile("\\s");

    private V1Parser() {
    }

    public static void parse(Logger logger, boolean lenient, Reader mappingSource, IConstantResolver constantResolver, Data data) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(mappingSource);){
            reader.readLine();
            String line = "";
            block15: while ((line = reader.readLine()) != null) {
                String[] tokens;
                if ((line = V1Parser.stripComment(line).trim()).isEmpty() || (tokens = V1Parser.tokenize(line)).length == 0) continue;
                switch (tokens[0]) {
                    case "constant": {
                        GroupDefinition group = V1Parser.parseGroupDefinition(logger, lenient, false, constantResolver, tokens, reader.getLineNumber());
                        if (group == null) continue block15;
                        data.visitGroupDefinition(group);
                        break;
                    }
                    case "flag": {
                        GroupDefinition group = V1Parser.parseGroupDefinition(logger, lenient, true, constantResolver, tokens, reader.getLineNumber());
                        if (group == null) continue block15;
                        data.visitGroupDefinition(group);
                        break;
                    }
                    case "unpick": {
                        data.visitTargetMethod(V1Parser.parseTargetMethodDefinition(tokens, reader.getLineNumber()));
                        break;
                    }
                    default: {
                        throw new UnpickSyntaxException(reader.getLineNumber(), "Unknown start token " + tokens[0]);
                    }
                }
            }
        }
    }

    private static String stripComment(String in) {
        int c = in.indexOf(35);
        return c == -1 ? in : in.substring(0, c);
    }

    private static String[] tokenize(String in) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : WHITESPACE_SPLITTER.split(in)) {
            if (s2.isEmpty()) continue;
            result.add(s2);
        }
        return result.toArray(new String[0]);
    }

    @Nullable
    private static GroupDefinition parseGroupDefinition(Logger logger, boolean lenient, boolean flags, IConstantResolver constantResolver, String[] tokens, int lineNumber) {
        DataType dataType;
        if (tokens.length != 4 && tokens.length != 6) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected 4 or 6. Found " + tokens.length);
        }
        String group = tokens[1];
        String owner = tokens[2];
        String name = tokens[3];
        if (tokens.length > 4) {
            dataType = V2Parser.parseType(tokens[5], lineNumber);
        } else {
            IConstantResolver.ResolvedConstant constant = constantResolver.resolveConstant(owner, name);
            if (constant == null) {
                Utils.throwOrWarn(logger, lenient, () -> "Cannot resolve constant " + owner + "." + name);
                return null;
            }
            dataType = V2Parser.parseType(constant.type().getDescriptor(), lineNumber);
        }
        DataType groupDataType = V2Parser.widenGroupType(dataType);
        GroupDefinition.Builder groupDefinition = GroupDefinition.Builder.named(groupDataType, group).constant(new FieldExpression(owner.replace('/', '.'), name, null, true));
        if (flags) {
            groupDefinition.flags();
        }
        return groupDefinition.build();
    }

    private static TargetMethod parseTargetMethodDefinition(String[] tokens, int lineNumber) {
        if (tokens.length < 4 || tokens.length % 2 != 0) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected an even number greater than or equal to 4. Found " + tokens.length);
        }
        String owner = tokens[1];
        String name = tokens[2];
        String desc = tokens[3];
        HashMap<Integer, String> parameterGroups = new HashMap<Integer, String>();
        for (int p = 5; p < tokens.length; p += 2) {
            try {
                int parameterIndex = Integer.parseInt(tokens[p - 1]);
                if (parameterGroups.put(parameterIndex, tokens[p]) == null) continue;
                throw new UnpickSyntaxException(lineNumber, "Duplicate parameter index " + parameterIndex);
            }
            catch (NumberFormatException e) {
                throw new UnpickSyntaxException(lineNumber, "Could not parse " + tokens[p - 1] + " as integer", e);
            }
        }
        return new TargetMethod(owner.replace('/', '.'), name, desc, parameterGroups, null);
    }
}

