/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.Literal;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.BinaryExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.CastExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.LiteralExpression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.UnaryExpression;
import daomephsta.unpick.impl.DataTypeUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public final class ExpressionEvaluator
extends ExpressionVisitor {
    private final IConstantResolver constantResolver;
    private final IInheritanceChecker inheritanceChecker;
    @Nullable
    private Object result;

    public ExpressionEvaluator(IConstantResolver constantResolver, IInheritanceChecker inheritanceChecker) {
        this.constantResolver = constantResolver;
        this.inheritanceChecker = inheritanceChecker;
    }

    @Nullable
    public Object getResult() {
        return this.result;
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.lhs.accept(this);
        Object left = this.result;
        binaryExpression.rhs.accept(this);
        Object right = this.result;
        DataType leftType = DataTypeUtils.getDataType(left);
        DataType rightType = DataTypeUtils.getDataType(right);
        DataType resultType = ExpressionEvaluator.getBinaryResultType(leftType, rightType);
        this.result = switch (binaryExpression.operator) {
            default -> throw new MatchException(null, null);
            case BinaryExpression.Operator.BIT_OR -> DataTypeUtils.cast(this.upcastAsLong(left) | this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.BIT_XOR -> DataTypeUtils.cast(this.upcastAsLong(left) ^ this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.BIT_AND -> DataTypeUtils.cast(this.upcastAsLong(left) & this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.BIT_SHIFT_LEFT -> DataTypeUtils.cast(this.upcastAsLong(left) << (int)this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.BIT_SHIFT_RIGHT -> DataTypeUtils.cast(this.upcastAsLong(left) >> (int)this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.BIT_SHIFT_RIGHT_UNSIGNED -> DataTypeUtils.cast(this.upcastAsLongUnsigned(left) >>> (int)this.upcastAsLong(right), resultType);
            case BinaryExpression.Operator.ADD -> {
                if (left instanceof String) {
                    yield String.valueOf(left) + this.asString(right);
                }
                if (right instanceof String) {
                    yield this.asString(left) + String.valueOf(right);
                }
                Long leftInteger = ExpressionEvaluator.upcastAsLongOrNull(left);
                Long rightInteger = ExpressionEvaluator.upcastAsLongOrNull(right);
                if (leftInteger != null && rightInteger != null) {
                    yield DataTypeUtils.cast(leftInteger + rightInteger, resultType);
                }
                yield DataTypeUtils.cast(this.upcastAsDouble(left) + this.upcastAsDouble(right), resultType);
            }
            case BinaryExpression.Operator.SUBTRACT -> {
                Long leftInteger = ExpressionEvaluator.upcastAsLongOrNull(left);
                Long rightInteger = ExpressionEvaluator.upcastAsLongOrNull(right);
                if (leftInteger != null && rightInteger != null) {
                    yield DataTypeUtils.cast(leftInteger - rightInteger, resultType);
                }
                yield DataTypeUtils.cast(this.upcastAsDouble(left) - this.upcastAsDouble(right), resultType);
            }
            case BinaryExpression.Operator.MULTIPLY -> {
                Long leftInteger = ExpressionEvaluator.upcastAsLongOrNull(left);
                Long rightInteger = ExpressionEvaluator.upcastAsLongOrNull(right);
                if (leftInteger != null && rightInteger != null) {
                    yield DataTypeUtils.cast(leftInteger * rightInteger, resultType);
                }
                yield DataTypeUtils.cast(this.upcastAsDouble(left) * this.upcastAsDouble(right), resultType);
            }
            case BinaryExpression.Operator.DIVIDE -> {
                Long leftInteger = ExpressionEvaluator.upcastAsLongOrNull(left);
                Long rightInteger = ExpressionEvaluator.upcastAsLongOrNull(right);
                if (leftInteger != null && rightInteger != null) {
                    if (rightInteger == 0L) {
                        throw new UnpickSyntaxException("Cannot divide " + leftInteger + " by zero");
                    }
                    yield DataTypeUtils.cast(leftInteger / rightInteger, resultType);
                }
                yield DataTypeUtils.cast(this.upcastAsDouble(left) / this.upcastAsDouble(right), resultType);
            }
            case BinaryExpression.Operator.MODULO -> {
                Long leftInteger = ExpressionEvaluator.upcastAsLongOrNull(left);
                Long rightInteger = ExpressionEvaluator.upcastAsLongOrNull(right);
                if (leftInteger != null && rightInteger != null) {
                    if (rightInteger == 0L) {
                        throw new UnpickSyntaxException("Cannot divide " + leftInteger + " by zero");
                    }
                    yield DataTypeUtils.cast(leftInteger % rightInteger, resultType);
                }
                yield DataTypeUtils.cast(this.upcastAsDouble(left) % this.upcastAsDouble(right), resultType);
            }
        };
    }

    @Override
    public void visitCastExpression(CastExpression castExpression) {
        castExpression.operand.accept(this);
        this.result = DataTypeUtils.cast(this.result, castExpression.castType);
    }

    @Override
    public void visitFieldExpression(FieldExpression fieldExpression) {
        String fieldName;
        String ownerName = fieldExpression.className.replace('.', '/');
        IConstantResolver.ResolvedConstant resolvedConstant = this.constantResolver.resolveConstant(ownerName, fieldName = Objects.requireNonNull(fieldExpression.fieldName, "Cannot resolve wildcard field expression"));
        if (resolvedConstant == null) {
            throw new UnpickSyntaxException("Could not resolve constant field " + fieldExpression.className + "." + fieldExpression.fieldName);
        }
        if (fieldExpression.fieldType != null && fieldExpression.fieldType != DataTypeUtils.asmTypeToDataType(resolvedConstant.type())) {
            throw new UnpickSyntaxException("Resolved field " + fieldExpression.className + "." + fieldExpression.fieldName + " has different type than expected");
        }
        if (fieldExpression.isStatic != resolvedConstant.isStatic()) {
            throw new UnpickSyntaxException("Staticness of resolved field " + fieldExpression.className + "." + fieldExpression.fieldName + " does not match expected staticness");
        }
        this.result = resolvedConstant.value();
    }

    /*
     * Loose catch block
     */
    @Override
    public void visitLiteralExpression(LiteralExpression literalExpression) {
        Object object;
        block17: {
            Literal literal;
            Literal literal2 = literal = literalExpression.literal;
            Objects.requireNonNull(literal2);
            Literal literal3 = literal2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Literal.Integer.class, Literal.Long.class, Literal.Float.class, Literal.Double.class, Literal.Character.class, Literal.String.class}, (Object)literal3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int n2;
                    Literal.Integer integer = (Literal.Integer)literal3;
                    int value = n2 = integer.value();
                    int ignored = n2 = integer.radix();
                    object = value;
                    break;
                }
                case 1: {
                    int n3;
                    long l;
                    Literal.Long longVal = (Literal.Long)literal3;
                    long value = l = longVal.value();
                    int ignored = n3 = longVal.radix();
                    object = value;
                    break;
                }
                case 2: {
                    float f;
                    Literal.Float float_ = (Literal.Float)literal3;
                    float value = f = float_.value();
                    object = Float.valueOf(value);
                    break;
                }
                case 3: {
                    double d;
                    Literal.Double double_ = (Literal.Double)literal3;
                    double value = d = double_.value();
                    object = value;
                    break;
                }
                case 4: {
                    char c;
                    Literal.Character character = (Literal.Character)literal3;
                    char value = c = character.value();
                    object = Character.valueOf(value);
                    break;
                }
                case 5: {
                    String string;
                    Literal.String string2 = (Literal.String)literal3;
                    String value = string = string2.value();
                    object = value;
                }
            }
            break block17;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        this.result = object;
    }

    @Override
    public void visitUnaryExpression(UnaryExpression unaryExpression) {
        unaryExpression.operand.accept(this);
        DataType resultType = DataTypeUtils.widenNarrowTypes(DataTypeUtils.getDataType(this.result));
        this.result = switch (unaryExpression.operator) {
            default -> throw new MatchException(null, null);
            case UnaryExpression.Operator.NEGATE -> {
                Long integer = ExpressionEvaluator.upcastAsLongOrNull(this.result);
                if (integer != null) {
                    yield DataTypeUtils.cast(-integer.longValue(), resultType);
                }
                yield DataTypeUtils.cast(-this.upcastAsDouble(this.result), resultType);
            }
            case UnaryExpression.Operator.BIT_NOT -> DataTypeUtils.cast(this.upcastAsLong(this.result) ^ 0xFFFFFFFFFFFFFFFFL, resultType);
        };
    }

    private long upcastAsLong(Object value) {
        Long result = ExpressionEvaluator.upcastAsLongOrNull(value);
        if (result == null) {
            throw new UnpickSyntaxException("Cannot interpret " + this.asString(value) + " as an integer");
        }
        return result;
    }

    @Nullable
    private static Long upcastAsLongOrNull(Object value) {
        if (!DataTypeUtils.isAssignable(DataType.LONG, DataTypeUtils.getDataType(value))) {
            return null;
        }
        return (Long)DataTypeUtils.cast(value, DataType.LONG);
    }

    private long upcastAsLongUnsigned(Object value) {
        long result = this.upcastAsLong(value);
        return value instanceof Long ? result : result & 0xFFFFFFFFL;
    }

    private double upcastAsDouble(Object value) {
        Double result = ExpressionEvaluator.upcastAsDoubleOrNull(value);
        if (result == null) {
            throw new UnpickSyntaxException("Cannot interpret " + this.asString(value) + " as a number");
        }
        return result;
    }

    @Nullable
    private static Double upcastAsDoubleOrNull(Object value) {
        if (!DataTypeUtils.isAssignable(DataType.DOUBLE, DataTypeUtils.getDataType(value))) {
            return null;
        }
        return (Double)DataTypeUtils.cast(value, DataType.DOUBLE);
    }

    public static DataType getBinaryResultType(DataType type1, DataType type2) {
        if (type1 == DataType.STRING || type2 == DataType.STRING) {
            return DataType.STRING;
        }
        if (DataTypeUtils.isPrimitive(type1) && DataTypeUtils.isPrimitive(type2)) {
            return DataTypeUtils.widenNarrowTypes(DataTypeUtils.getCommonSuperType(type1, type2));
        }
        return type1;
    }

    private String asString(Object value) {
        if (value instanceof Type) {
            Type type = (Type)value;
            return switch (type.getSort()) {
                case 9 -> "class " + type.getDescriptor().replace('/', '.');
                case 10 -> {
                    IInheritanceChecker.ClassInfo classInfo = this.inheritanceChecker.getClassInfo(type.getInternalName());
                    if (classInfo != null && classInfo.isInterface()) {
                        yield "interface " + type.getInternalName().replace('/', '.');
                    }
                    yield "class " + type.getInternalName().replace('/', '.');
                }
                default -> type.getClassName();
            };
        }
        return String.valueOf(value);
    }
}

