/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.api.constantgroupers.ConstantGroup;
import daomephsta.unpick.api.constantgroupers.IConstantGrouper;
import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.constantmappers.datadriven.parser.MemberKey;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Reader;
import daomephsta.unpick.constantmappers.datadriven.tree.DataType;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetAnnotation;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetField;
import daomephsta.unpick.constantmappers.datadriven.tree.TargetMethod;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.DataTypeUtils;
import daomephsta.unpick.impl.constantmappers.datadriven.ExpressionGenerator;
import daomephsta.unpick.impl.constantmappers.datadriven.data.ConstantReplacementInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.data.Data;
import daomephsta.unpick.impl.constantmappers.datadriven.data.GroupInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.data.ScopedGroupInfo;
import daomephsta.unpick.impl.constantmappers.datadriven.parser.V1Parser;
import daomephsta.unpick.impl.constantmappers.datadriven.parser.v2.V2Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;

public class DataDrivenConstantGrouper
implements IConstantGrouper {
    private static final int MAX_VERSION_HEADER_LENGTH = "unpick v3".length();
    private final Logger logger;
    private final boolean lenient;
    private final IConstantResolver constantResolver;
    private final IInheritanceChecker inheritanceChecker;
    private final IMemberChecker memberChecker;
    private final Data data;
    private final Map<MemberKey, TargetMethod> targetMethodCache = new ConcurrentHashMap<MemberKey, TargetMethod>();
    private final Set<MemberKey> noTargetMethodCache = ConcurrentHashMap.newKeySet();
    private final Map<MemberKey, String> resolvedMethodOwnerCache = new ConcurrentHashMap<MemberKey, String>();
    private final ConstantGroup defaultGroup = new ConstantGroup("<default>", this::replaceDefault);

    public DataDrivenConstantGrouper(Logger logger, boolean lenient, IConstantResolver constantResolver, IInheritanceChecker inheritanceChecker, IMemberChecker memberChecker) {
        this.logger = logger;
        this.lenient = lenient;
        this.constantResolver = constantResolver;
        this.inheritanceChecker = inheritanceChecker;
        this.memberChecker = memberChecker;
        this.data = new Data(logger, lenient, constantResolver, inheritanceChecker);
    }

    public void loadData(Reader mappingSource) throws IOException {
        BufferedReader reader = new BufferedReader(mappingSource);
        reader.mark(MAX_VERSION_HEADER_LENGTH + 2);
        String versionHeader = reader.readLine();
        if (versionHeader.length() > MAX_VERSION_HEADER_LENGTH) {
            throw new UnpickSyntaxException(1, "Unknown version or missing version header: " + versionHeader);
        }
        reader.reset();
        switch (versionHeader) {
            case "v1": {
                V1Parser.parse(this.logger, this.lenient, reader, this.constantResolver, this.data);
                break;
            }
            case "v2": {
                V2Parser.parse(this.logger, this.lenient, reader, this.constantResolver, this.data);
                break;
            }
            case "unpick v3": 
            case "unpick v4": {
                new UnpickV3Reader(reader).accept(this.data);
                break;
            }
            default: {
                throw new UnpickSyntaxException(1, "Unknown version or missing version header: " + versionHeader);
            }
        }
    }

    public void loadData(Consumer<UnpickV3Visitor> dataProvider) {
        dataProvider.accept(this.data);
    }

    public int groupCount() {
        return this.data.defaultGroups.size() + this.data.groups.size();
    }

    public int targetFieldCount() {
        return this.data.targetFields.size();
    }

    public int targetMethodCount() {
        return this.data.targetMethods.size();
    }

    @Override
    @Nullable
    public ConstantGroup getFieldGroup(String fieldOwner, String fieldName, String fieldDescriptor) {
        String annotationGroup;
        TargetField targetField = this.data.targetFields.get(new MemberKey(fieldOwner.replace('/', '.'), fieldName, fieldDescriptor));
        if (targetField != null) {
            return this.getGroupByName(targetField.groupName());
        }
        IMemberChecker.MemberInfo field = this.memberChecker.getField(fieldOwner, fieldName, fieldDescriptor);
        if (field != null && (annotationGroup = this.getGroupFromAnnotations(field.annotations())) != null) {
            return this.getGroupByName(annotationGroup);
        }
        return null;
    }

    @Override
    @Nullable
    public ConstantGroup getMethodReturnGroup(String methodOwner, String methodName, String methodDescriptor) {
        String annotationGroup;
        TargetMethod targetMethod = this.findTargetMethod(methodOwner, methodName, methodDescriptor);
        if (targetMethod != null && targetMethod.returnGroup() != null) {
            return this.getGroupByName(targetMethod.returnGroup());
        }
        IMemberChecker.MemberInfo method = this.memberChecker.getMethod(this.resolveMethodOwner(methodOwner, methodName, methodDescriptor), methodName, methodDescriptor);
        if (method != null && (annotationGroup = this.getGroupFromAnnotations(method.annotations())) != null) {
            return this.getGroupByName(annotationGroup);
        }
        return null;
    }

    @Override
    @Nullable
    public ConstantGroup getMethodParameterGroup(String methodOwner, String methodName, String methodDescriptor, int parameterIndex) {
        String annotationGroup;
        String groupName;
        TargetMethod targetMethod = this.findTargetMethod(methodOwner, methodName, methodDescriptor);
        if (targetMethod != null && (groupName = targetMethod.paramGroups().get(parameterIndex)) != null) {
            return this.getGroupByName(groupName);
        }
        IMemberChecker.ParameterInfo parameter = this.memberChecker.getParameter(this.resolveMethodOwner(methodOwner, methodName, methodDescriptor), methodName, methodDescriptor, parameterIndex);
        if (parameter != null && (annotationGroup = this.getGroupFromAnnotations(parameter.annotations())) != null) {
            return this.getGroupByName(annotationGroup);
        }
        return null;
    }

    private TargetMethod findTargetMethod(String methodOwner, String methodName, String methodDescriptor) {
        IInheritanceChecker.ClassInfo classInfo;
        MemberKey memberKey = new MemberKey(methodOwner.replace('/', '.'), methodName, methodDescriptor);
        if (this.noTargetMethodCache.contains(memberKey)) {
            return null;
        }
        TargetMethod targetMethod = this.targetMethodCache.get(memberKey);
        if (targetMethod != null) {
            return targetMethod;
        }
        targetMethod = this.data.targetMethods.get(memberKey);
        if (targetMethod == null && (classInfo = this.inheritanceChecker.getClassInfo(methodOwner)) != null) {
            if (classInfo.superClass() != null) {
                targetMethod = this.findTargetMethod(classInfo.superClass(), methodName, methodDescriptor);
            }
            if (targetMethod == null) {
                String itf;
                String[] stringArray = classInfo.interfaces();
                int n = stringArray.length;
                for (int i = 0; i < n && (targetMethod = this.findTargetMethod(itf = stringArray[i], methodName, methodDescriptor)) == null; ++i) {
                }
            }
        }
        if (targetMethod == null) {
            this.noTargetMethodCache.add(memberKey);
        } else {
            this.targetMethodCache.put(memberKey, targetMethod);
        }
        return targetMethod;
    }

    private String resolveMethodOwner(String owner, String name, String desc) {
        return Objects.requireNonNullElse(this.recursiveResolveMethodOwner(owner, name, desc), owner);
    }

    @Nullable
    private String recursiveResolveMethodOwner(String owner, String name, String desc) {
        MemberKey memberKey = new MemberKey(owner, name, desc);
        String resolvedOwner = this.resolvedMethodOwnerCache.get(memberKey);
        if (resolvedOwner != null) {
            return resolvedOwner;
        }
        if (this.memberChecker.getMethod(owner, name, desc) != null) {
            resolvedOwner = owner;
        } else {
            IInheritanceChecker.ClassInfo classInfo = this.inheritanceChecker.getClassInfo(owner);
            if (classInfo != null) {
                if (classInfo.superClass() != null) {
                    resolvedOwner = this.recursiveResolveMethodOwner(classInfo.superClass(), name, desc);
                }
                if (resolvedOwner == null) {
                    String itf;
                    String[] stringArray = classInfo.interfaces();
                    int n = stringArray.length;
                    for (int i = 0; i < n && (resolvedOwner = this.recursiveResolveMethodOwner(itf = stringArray[i], name, desc)) == null; ++i) {
                    }
                }
            }
        }
        if (resolvedOwner != null) {
            this.resolvedMethodOwnerCache.put(memberKey, resolvedOwner);
        }
        return resolvedOwner;
    }

    @Nullable
    private String getGroupFromAnnotations(List<String> annotations) {
        for (String annotation : annotations) {
            TargetAnnotation targetAnnotation = this.data.targetAnnotations.get(annotation.replace('/', '.'));
            if (targetAnnotation == null) continue;
            return targetAnnotation.groupName();
        }
        return null;
    }

    @Override
    public ConstantGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    private ConstantGroup getGroupByName(String name) {
        GroupInfo groupInfo = this.data.groups.get(name);
        if (groupInfo == null) {
            return null;
        }
        return new ConstantGroup(name, context -> this.replaceWithGroup(context, groupInfo));
    }

    private void replaceDefault(IReplacementGenerator.IContext context) {
        List<DataType> compatibleTypes;
        AbstractInsnNode target = context.getTarget();
        if (!AbstractInsnNodes.hasLiteralValue(target)) {
            return;
        }
        Object literal = AbstractInsnNodes.getLiteralValue(target);
        DataType literalType = DataTypeUtils.getDataType(literal);
        DataType dataType = literalType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LONG", "FLOAT", "DOUBLE"}, (DataType)dataType, n)) {
            case 0: {
                List<DataType> list = List.of(DataType.LONG, DataType.INT);
                break;
            }
            case 1: {
                List<DataType> list = List.of(DataType.FLOAT, DataType.LONG, DataType.INT);
                break;
            }
            case 2: {
                List<DataType> list = List.of(DataType.DOUBLE, DataType.FLOAT, DataType.LONG, DataType.INT);
                break;
            }
            case -1: {
                List<DataType> list;
                AbstractInsnNode nextInsn = AbstractInsnNodes.nextInstruction(target);
                if (nextInsn == null) {
                    list = null;
                    break;
                }
                Frame<IReplacementGenerator.IDataflowValue> frame = context.getDataflowFrame(nextInsn);
                if (frame == null) {
                    list = null;
                    break;
                }
                Set<DataType> typeInterpretations = frame.getStack(frame.getStackSize() - 1).getTypeInterpretations();
                if (typeInterpretations.contains((Object)DataType.STRING)) {
                    literalType = DataType.STRING;
                    list = List.of(DataType.STRING);
                    break;
                }
                if (typeInterpretations.contains((Object)DataType.CLASS)) {
                    literalType = DataType.CLASS;
                    list = List.of(DataType.CLASS);
                    break;
                }
                list = null;
                break;
            }
            default: {
                List<DataType> list = compatibleTypes = List.of(literalType);
            }
        }
        if (compatibleTypes == null) {
            return;
        }
        for (DataType compatibleType : compatibleTypes) {
            GroupInfo defaultGroup;
            Object castedLiteral = DataTypeUtils.tryCastExact(literal, DataTypeUtils.widenNarrowTypes(compatibleType));
            if (castedLiteral == null && literal != null || (defaultGroup = this.data.defaultGroups.get((Object)compatibleType)) == null) continue;
            for (ScopedGroupInfo scope : DataDrivenConstantGrouper.findMatchingScopes(context, defaultGroup)) {
                ConstantReplacementInfo replacementInfo = scope.constantReplacementMap.get(castedLiteral);
                if (replacementInfo == null || replacementInfo.strict() && compatibleType != literalType) continue;
                DataType narrowedLiteralType = DataDrivenConstantGrouper.getNarrowedLiteralType(context, target, literalType, literal);
                ExpressionGenerator.replaceWithExpression(context, defaultGroup, replacementInfo.replacementExpression(), narrowedLiteralType);
                return;
            }
        }
    }

    private void replaceWithGroup(IReplacementGenerator.IContext context, GroupInfo groupInfo) {
        AbstractInsnNode target = context.getTarget();
        if (!AbstractInsnNodes.hasLiteralValue(target)) {
            return;
        }
        Object literal = AbstractInsnNodes.getLiteralValue(target);
        DataType literalType = DataTypeUtils.getDataType(literal);
        if (literal == null ? DataTypeUtils.isPrimitive(groupInfo.dataType) : !DataTypeUtils.isAssignable(literalType, groupInfo.dataType)) {
            return;
        }
        Object castedLiteral = DataTypeUtils.tryCastExact(literal, groupInfo.dataType);
        if (castedLiteral == null && literal != null) {
            return;
        }
        Long longLiteral = (Long)DataTypeUtils.tryCastExact(literal, DataType.LONG);
        if (groupInfo.flags && DataTypeUtils.isAssignable(DataType.LONG, literalType) && longLiteral != null && !longLiteral.equals(0L) && !longLiteral.equals(-1L)) {
            DataType narrowedLiteralType = DataDrivenConstantGrouper.getNarrowedLiteralType(context, target, literalType, literal);
            Expression flagsExpression = ExpressionGenerator.generateFlagsExpression(context, groupInfo, longLiteral, literalType, narrowedLiteralType);
            if (flagsExpression != null) {
                ExpressionGenerator.replaceWithExpression(context, groupInfo, flagsExpression, narrowedLiteralType);
            }
        } else {
            for (ScopedGroupInfo scope : DataDrivenConstantGrouper.findMatchingScopes(context, groupInfo)) {
                ConstantReplacementInfo replacementInfo = scope.constantReplacementMap.get(castedLiteral);
                if (replacementInfo == null || replacementInfo.strict() && literalType != groupInfo.dataType) continue;
                DataType narrowedLiteralType = DataDrivenConstantGrouper.getNarrowedLiteralType(context, target, literalType, literal);
                ExpressionGenerator.replaceWithExpression(context, groupInfo, replacementInfo.replacementExpression(), narrowedLiteralType);
                return;
            }
        }
    }

    private static DataType getNarrowedLiteralType(IReplacementGenerator.IContext context, AbstractInsnNode target, DataType literalType, Object literal) {
        if (literalType != DataType.INT) {
            return literalType;
        }
        int value = (Integer)literal;
        AbstractInsnNode nextInsn = AbstractInsnNodes.nextInstruction(target);
        if (nextInsn == null) {
            return literalType;
        }
        Frame<IReplacementGenerator.IDataflowValue> dataflowFrame = context.getDataflowFrame(nextInsn);
        if (dataflowFrame == null) {
            return literalType;
        }
        Set<DataType> narrowTypeInterpretations = dataflowFrame.getStack(dataflowFrame.getStackSize() - 1).getTypeInterpretations();
        if (narrowTypeInterpretations.contains((Object)DataType.BYTE) && value >= -128 && value <= 127) {
            return DataType.BYTE;
        }
        if (narrowTypeInterpretations.contains((Object)DataType.SHORT) && value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return DataType.SHORT;
        }
        if (narrowTypeInterpretations.contains((Object)DataType.CHAR) && value >= 0 && value <= 65535) {
            return DataType.CHAR;
        }
        return literalType;
    }

    static List<ScopedGroupInfo> findMatchingScopes(IReplacementGenerator.IContext context, GroupInfo groupInfo) {
        ScopedGroupInfo packageScope;
        String packageName;
        ScopedGroupInfo classScope;
        ArrayList<ScopedGroupInfo> scopes = new ArrayList<ScopedGroupInfo>(1);
        String className = context.getContainingClass().name.replace('/', '.');
        MethodNode method = context.getContainingMethod();
        ScopedGroupInfo methodScope = groupInfo.methodScopes.get(new MemberKey(className, method.name, method.desc));
        if (methodScope != null) {
            scopes.add(methodScope);
        }
        if ((classScope = groupInfo.classScopes.get(className)) != null) {
            scopes.add(classScope);
        }
        if ((packageName = DataDrivenConstantGrouper.getPackageName(className)) != null && (packageScope = groupInfo.packageScopes.get(packageName)) != null) {
            scopes.add(packageScope);
        }
        scopes.add(groupInfo.globalScope);
        return scopes;
    }

    @Nullable
    private static String getPackageName(String className) {
        int dotIndex = className.lastIndexOf(46);
        return dotIndex == -1 ? null : className.substring(0, dotIndex);
    }
}

