/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.classresolvers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;

public class JarClassResolver
implements IClassResolver {
    private final ZipFile zipFile;

    public JarClassResolver(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    @Nullable
    public ClassNode resolveClass(String internalName) {
        ClassNode classNode;
        block9: {
            ZipEntry entry = this.zipFile.getEntry(internalName + ".class");
            if (entry == null) {
                return null;
            }
            InputStream is = this.zipFile.getInputStream(entry);
            try {
                ClassReader classReader = new ClassReader(is);
                ClassNode classNode2 = new ClassNode();
                classReader.accept(classNode2, 2);
                classNode = classNode2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
        }
        return classNode;
    }
}

