/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.classresolvers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.impl.Utils;
import daomephsta.unpick.impl.constantresolvers.ChainConstantResolver;
import daomephsta.unpick.impl.inheritancecheckers.ChainInheritanceChecker;
import daomephsta.unpick.impl.membercheckers.ChainMemberChecker;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class ChainClassResolver
implements IClassResolver {
    private final IClassResolver[] resolvers;

    public ChainClassResolver(IClassResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    @Nullable
    public ClassNode resolveClass(String internalName) {
        for (IClassResolver resolver : this.resolvers) {
            ClassNode cn = resolver.resolveClass(internalName);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }

    @Override
    public IConstantResolver asConstantResolver() {
        IConstantResolver[] constantResolvers = new IConstantResolver[this.resolvers.length];
        for (int i = 0; i < this.resolvers.length; ++i) {
            constantResolvers[i] = this.resolvers[i].asConstantResolver();
        }
        return new ChainConstantResolver(constantResolvers);
    }

    @Override
    public IInheritanceChecker asInheritanceChecker() {
        IInheritanceChecker[] inheritanceCheckers = new IInheritanceChecker[this.resolvers.length];
        for (int i = 0; i < this.resolvers.length; ++i) {
            inheritanceCheckers[i] = this.resolvers[i].asInheritanceChecker();
        }
        return new ChainInheritanceChecker(inheritanceCheckers);
    }

    @Override
    public IMemberChecker asMemberChecker() {
        IMemberChecker[] memberCheckers = new IMemberChecker[this.resolvers.length];
        for (int i = 0; i < this.resolvers.length; ++i) {
            memberCheckers[i] = this.resolvers[i].asMemberChecker();
        }
        return new ChainMemberChecker(memberCheckers);
    }

    @Override
    public IClassResolver chain(IClassResolver ... others) {
        return new ChainClassResolver(Utils.concat(this.resolvers, others));
    }
}

