/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public final class Utils {
    private Utils() {
    }

    public static String visitableToString(Consumer<MethodVisitor> visitable) {
        StringWriter w = new StringWriter();
        try (PrintWriter pw = new PrintWriter(w);){
            Textifier printer = new Textifier();
            TraceMethodVisitor tracer = new TraceMethodVisitor(printer);
            visitable.accept(tracer);
            printer.print(pw);
        }
        return w.toString();
    }

    public static boolean isIntegral(Object literal) {
        return literal instanceof Byte || literal instanceof Short || literal instanceof Integer || literal instanceof Long;
    }

    public static boolean isFloatingPoint(Object literal) {
        return literal instanceof Float || literal instanceof Double;
    }

    public static <T> T[] prepend(T value, T[] array) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        newArray[0] = value;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        Object[] newArray = (Object[])Array.newInstance(first.getClass().getComponentType(), first.length + second.length);
        System.arraycopy(first, 0, newArray, 0, first.length);
        System.arraycopy(second, 0, newArray, first.length, second.length);
        return newArray;
    }

    public static void throwOrWarn(Logger logger, boolean warn, Supplier<String> message) {
        if (!warn) {
            throw new UnpickSyntaxException(message.get());
        }
        logger.warning(message);
    }
}

