/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api.constantgroupers;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.classresolvers.IMemberChecker;
import daomephsta.unpick.api.constantgroupers.IConstantGrouper;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.impl.constantmappers.datadriven.DataDrivenConstantGrouper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.logging.Logger;

public final class ConstantGroupers {
    private ConstantGroupers() {
    }

    public static DataDrivenBuilder dataDriven() {
        return new DataDrivenBuilder();
    }

    public static final class DataDrivenBuilder {
        private Logger logger;
        private boolean lenient = false;
        private IConstantResolver constantResolver;
        private IInheritanceChecker inheritanceChecker;
        private IMemberChecker memberChecker;
        private String methodWhichInitializedResult;
        private DataDrivenConstantGrouper result;

        private DataDrivenBuilder() {
        }

        public DataDrivenBuilder logger(Logger logger) {
            this.ensureGrouperNotInitialized("logger");
            this.logger = logger;
            return this;
        }

        public DataDrivenBuilder lenient(boolean lenient) {
            this.ensureGrouperNotInitialized("lenient");
            this.lenient = lenient;
            return this;
        }

        public DataDrivenBuilder classResolver(IClassResolver classResolver) {
            this.ensureGrouperNotInitialized("classResolver");
            this.constantResolver = classResolver.asConstantResolver();
            this.inheritanceChecker = classResolver.asInheritanceChecker();
            this.memberChecker = classResolver.asMemberChecker();
            return this;
        }

        public DataDrivenBuilder constantResolver(IConstantResolver constantResolver) {
            this.ensureGrouperNotInitialized("constantResolver");
            this.constantResolver = constantResolver;
            return this;
        }

        public DataDrivenBuilder inheritanceChecker(IInheritanceChecker inheritanceChecker) {
            this.ensureGrouperNotInitialized("inheritanceChecker");
            this.inheritanceChecker = inheritanceChecker;
            return this;
        }

        public DataDrivenBuilder memberChecker(IMemberChecker memberChecker) {
            this.ensureGrouperNotInitialized("memberChecker");
            this.memberChecker = memberChecker;
            return this;
        }

        public DataDrivenBuilder mappingSource(InputStream mappingSource) throws IOException {
            return this.mappingSource(new InputStreamReader(mappingSource));
        }

        public DataDrivenBuilder mappingSource(Reader mappingSource) throws IOException {
            this.ensureGrouperInitialized("mappingSource");
            this.result.loadData(mappingSource);
            return this;
        }

        public DataDrivenBuilder mappingSource(Consumer<UnpickV3Visitor> dataProvider) {
            this.ensureGrouperInitialized("mappingSource");
            this.result.loadData(dataProvider);
            return this;
        }

        public IConstantGrouper build() {
            this.ensureGrouperInitialized("build");
            this.logger.info(() -> String.format("Loaded %d constant groups, %d target fields and %d target methods", this.result.groupCount(), this.result.targetFieldCount(), this.result.targetMethodCount()));
            return this.result;
        }

        private void ensureGrouperNotInitialized(String methodName) {
            if (this.result != null) {
                throw new IllegalStateException("Cannot call " + methodName + " after " + this.methodWhichInitializedResult);
            }
        }

        private void ensureGrouperInitialized(String methodName) {
            if (this.constantResolver == null) {
                throw new IllegalStateException("Cannot call " + methodName + " without setting the constant resolver");
            }
            if (this.inheritanceChecker == null) {
                throw new IllegalStateException("Cannot call " + methodName + " without setting the inheritance checker");
            }
            if (this.memberChecker == null) {
                throw new IllegalStateException("Cannot call " + methodName + " without setting the member checker");
            }
            if (this.logger == null) {
                this.logger = Logger.getLogger("unpick");
            }
            if (this.result == null) {
                this.methodWhichInitializedResult = methodName;
                this.result = new DataDrivenConstantGrouper(this.logger, this.lenient, this.constantResolver, this.inheritanceChecker, this.memberChecker);
            }
        }
    }
}

