/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api;

import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.api.constantgroupers.ConstantGroup;
import daomephsta.unpick.api.constantgroupers.IConstantGrouper;
import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.UnpickInterpreter;
import daomephsta.unpick.impl.UnpickValue;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.ReplacementSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;

public final class ConstantUninliner {
    private final Logger logger;
    private final IConstantGrouper grouper;
    private final IClassResolver classResolver;
    private final IConstantResolver constantResolver;
    private final IInheritanceChecker inheritanceChecker;

    private ConstantUninliner(Logger logger, IConstantGrouper grouper, IClassResolver classResolver, IConstantResolver constantResolver, IInheritanceChecker inheritanceChecker) {
        this.grouper = grouper;
        this.classResolver = classResolver;
        this.constantResolver = constantResolver;
        this.inheritanceChecker = inheritanceChecker;
        this.logger = logger;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void transform(ClassNode classNode) {
        HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
        HashMap<String, Frame<UnpickValue>[]> frames = new HashMap<String, Frame<UnpickValue>[]>();
        for (MethodNode method : classNode.methods) {
            String methodKey = ConstantUninliner.getMethodKey(method);
            methods.put(methodKey, method);
            frames.put(methodKey, this.analyzeMethod(classNode, method));
        }
        Map<String, List<LambdaUsage>> lambdaUsages = this.indexLambdaUsages(classNode);
        ArrayList<ReplacementSet> replacements = new ArrayList<ReplacementSet>();
        for (MethodNode method : classNode.methods) {
            ReplacementSet replacementsForMethod = this.transformMethod(classNode, method, new MethodTransformContext(methods, frames, lambdaUsages, new HashSet<String>()));
            if (replacementsForMethod == null) continue;
            replacements.add(replacementsForMethod);
        }
        replacements.forEach(ReplacementSet::apply);
    }

    public void transformMethod(ClassNode methodOwner, MethodNode method) {
        Frame<UnpickValue>[] frames = this.analyzeMethod(methodOwner, method);
        if (frames != null) {
            ReplacementSet replacements = this.transformMethod(methodOwner, method, new MethodTransformContext(Map.of(ConstantUninliner.getMethodKey(method), method), Map.of(ConstantUninliner.getMethodKey(method), frames), Map.of(), new HashSet<String>()));
            if (replacements != null) {
                replacements.apply();
            } else {
                this.logger.log(Level.WARNING, () -> "No replacements for analyzed method " + ConstantUninliner.getMethodKey(method) + "?!");
            }
        }
    }

    @Nullable
    private ReplacementSet transformMethod(ClassNode methodOwner, MethodNode method, MethodTransformContext transformContext) {
        try {
            Frame<UnpickValue>[] frames = transformContext.frames.get(ConstantUninliner.getMethodKey(method));
            if (frames == null) {
                return null;
            }
            this.logger.log(Level.FINEST, () -> String.format("Transforming method %s.%s%s", methodOwner.name, method.name, method.desc));
            ReplacementSet replacementSet = new ReplacementSet(method.instructions);
            HashMap<AbstractInsnNode, ConstantGroup> groups = new HashMap<AbstractInsnNode, ConstantGroup>();
            HashSet<AbstractInsnNode> ungrouped = new HashSet<AbstractInsnNode>();
            for (int index = 0; index < method.instructions.size(); ++index) {
                Frame<UnpickValue> frame;
                AbstractInsnNode insn = method.instructions.get(index);
                if (!AbstractInsnNodes.hasLiteralValue(insn) || ungrouped.contains(insn)) continue;
                Frame<UnpickValue> frame2 = frame = index + 1 >= frames.length ? null : frames[index + 1];
                if (frame == null) continue;
                UnpickValue unpickValue = frame.getStack(frame.getStackSize() - 1);
                ConstantGroup group = (ConstantGroup)groups.get(insn);
                if (group == null) {
                    group = this.findGroup(methodOwner.name, method, unpickValue, transformContext);
                    if (group == null) {
                        group = this.grouper.getDefaultGroup();
                    }
                    if (group == null) {
                        ungrouped.addAll(unpickValue.getUsages());
                    } else {
                        for (AbstractInsnNode usage : unpickValue.getUsages()) {
                            groups.put(usage, group);
                        }
                    }
                }
                if (group == null || this.isAssigningToConstant(insn)) continue;
                ReplacementInstructionGenerator.Context context = new ReplacementInstructionGenerator.Context(this.classResolver, this.constantResolver, this.inheritanceChecker, replacementSet, methodOwner, method, insn, frames, this.logger);
                group.apply(context);
            }
            return replacementSet;
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, String.format("Failed to transform method %s.%s%s", methodOwner.name, method.name, method.desc), e);
            return null;
        }
    }

    @Nullable
    private Frame<UnpickValue>[] analyzeMethod(ClassNode methodOwner, MethodNode method) {
        this.logger.log(Level.FINEST, () -> String.format("Running dataflow on %s.%s%s", methodOwner.name, method.name, method.desc));
        try {
            return new Analyzer<UnpickValue>(new UnpickInterpreter(method, this.inheritanceChecker)).analyze(methodOwner.name, method);
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, String.format("Dataflow on %s.%s%s failed", methodOwner.name, method.name, method.desc), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ConstantGroup findGroup(String methodOwner, MethodNode method, UnpickValue unpickValue, MethodTransformContext context) {
        if (!context.checkedMethods.add(ConstantUninliner.getMethodKey(method))) {
            return null;
        }
        try {
            ConstantGroup g2;
            ConstantGroup group = null;
            Iterator<Object> iterator = unpickValue.getParameterSources().iterator();
            while (iterator.hasNext()) {
                int parameterSource = iterator.next();
                g2 = this.processParameterSource(methodOwner, method, parameterSource, context);
                if (g2 == null) continue;
                if (group != null && !g2.getName().equals(group.getName())) {
                    this.warnGroupConflict(g2, group, methodOwner, method);
                    ConstantGroup constantGroup = null;
                    return constantGroup;
                }
                group = g2;
            }
            for (IReplacementGenerator.IParameterUsage paramUsage : unpickValue.getParameterUsages()) {
                g2 = this.processParameterUsage(methodOwner, paramUsage, context);
                if (g2 == null) continue;
                if (group != null && !g2.getName().equals(group.getName())) {
                    this.warnGroupConflict(g2, group, methodOwner, method);
                    ConstantGroup constantGroup = null;
                    return constantGroup;
                }
                group = g2;
            }
            for (AbstractInsnNode usage : unpickValue.getUsages()) {
                g2 = this.processUsage(methodOwner, method, usage, context);
                if (g2 == null) continue;
                if (group != null && !g2.getName().equals(group.getName())) {
                    this.warnGroupConflict(g2, group, methodOwner, method);
                    ConstantGroup constantGroup = null;
                    return constantGroup;
                }
                group = g2;
            }
            iterator = group;
            return iterator;
        }
        finally {
            context.checkedMethods.remove(ConstantUninliner.getMethodKey(method));
        }
    }

    @Nullable
    private ConstantGroup processParameterSource(String methodOwner, MethodNode method, int parameterSource, MethodTransformContext context) {
        ConstantGroup group = this.grouper.getMethodParameterGroup(methodOwner, method.name, method.desc, parameterSource);
        if (group != null) {
            return group;
        }
        List<LambdaUsage> lambdaUsagesForMethod = context.lambdaUsages.get(ConstantUninliner.getMethodKey(method));
        if (lambdaUsagesForMethod != null) {
            for (LambdaUsage lambdaUsage : lambdaUsagesForMethod) {
                String samDesc;
                String samName;
                Frame<UnpickValue> frame;
                Frame<UnpickValue>[] containingMethodFrames = context.frames.get(ConstantUninliner.getMethodKey(lambdaUsage.method));
                if (containingMethodFrames == null || (frame = containingMethodFrames[lambdaUsage.method.instructions.indexOf(lambdaUsage.indy)]) == null) continue;
                int numCaptures = Type.getArgumentCount(lambdaUsage.indy.desc);
                if (!ConstantUninliner.isStaticLambdaInvocation(lambdaUsage.indy)) {
                    --numCaptures;
                }
                if (parameterSource < numCaptures) {
                    ConstantGroup g2;
                    UnpickValue lambdaCapture = frame.getStack(frame.getStackSize() - numCaptures + parameterSource);
                    if (lambdaCapture == null || (g2 = this.findGroup(methodOwner, lambdaUsage.method, lambdaCapture, context)) == null) continue;
                    if (group != null && !g2.getName().equals(group.getName())) {
                        this.warnGroupConflict(g2, group, methodOwner, method);
                        return null;
                    }
                    group = g2;
                    continue;
                }
                String samOwner = Type.getReturnType(lambdaUsage.indy.desc).getInternalName();
                ConstantGroup g3 = this.grouper.getMethodParameterGroup(samOwner, samName = lambdaUsage.indy.name, samDesc = ((Type)lambdaUsage.indy.bsmArgs[0]).getDescriptor(), parameterSource - numCaptures);
                if (g3 == null) continue;
                if (group != null && !g3.getName().equals(group.getName())) {
                    this.warnGroupConflict(g3, group, methodOwner, method);
                    return null;
                }
                group = g3;
            }
        }
        return group;
    }

    @Nullable
    private ConstantGroup processParameterUsage(String methodOwner, IReplacementGenerator.IParameterUsage paramUsage, MethodTransformContext context) {
        AbstractInsnNode abstractInsnNode = paramUsage.getMethodInvocation();
        if (abstractInsnNode instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)abstractInsnNode;
            if ("java/lang/invoke/LambdaMetafactory".equals(indy.bsm.getOwner())) {
                Handle lambdaMethod = (Handle)indy.bsmArgs[1];
                boolean staticLambdaInvocation = ConstantUninliner.isStaticLambdaInvocation(indy);
                if (!staticLambdaInvocation && paramUsage.getParamIndex() == 0) {
                    return null;
                }
                int paramIndex = staticLambdaInvocation ? paramUsage.getParamIndex() : paramUsage.getParamIndex() - 1;
                ConstantGroup group = this.grouper.getMethodParameterGroup(lambdaMethod.getOwner(), lambdaMethod.getName(), lambdaMethod.getDesc(), paramIndex);
                if (group != null) {
                    return group;
                }
                if (!lambdaMethod.getOwner().equals(methodOwner)) {
                    return null;
                }
                String lambdaKey = ConstantUninliner.getMethodKey(lambdaMethod);
                Frame<UnpickValue>[] lambdaFrames = context.frames.get(lambdaKey);
                if (lambdaFrames == null || lambdaFrames.length == 0) {
                    return null;
                }
                Frame<UnpickValue> firstLambdaFrame = lambdaFrames[0];
                if (firstLambdaFrame == null) {
                    return null;
                }
                int localIndex = lambdaMethod.getTag() == 6 ? 0 : 1;
                Type[] lambdaArgs = Type.getArgumentTypes(lambdaMethod.getDesc());
                for (int i = 0; i < lambdaArgs.length && i != paramIndex; ++i) {
                    localIndex += lambdaArgs[i].getSize();
                }
                UnpickValue lambdaParam = firstLambdaFrame.getLocal(localIndex);
                if (lambdaParam == null) {
                    return null;
                }
                return this.findGroup(methodOwner, context.methods.get(lambdaKey), lambdaParam, context);
            }
            return null;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)paramUsage.getMethodInvocation();
        return this.grouper.getMethodParameterGroup(methodInsn.owner, methodInsn.name, methodInsn.desc, paramUsage.getParamIndex());
    }

    @Nullable
    private ConstantGroup processUsage(String methodOwner, MethodNode enclosingMethod, AbstractInsnNode usage, MethodTransformContext context) {
        if (usage.getType() == 4) {
            FieldInsnNode fieldInsn = (FieldInsnNode)usage;
            return this.grouper.getFieldGroup(fieldInsn.owner, fieldInsn.name, fieldInsn.desc);
        }
        if (usage.getType() == 5) {
            MethodInsnNode method = (MethodInsnNode)usage;
            return this.grouper.getMethodReturnGroup(method.owner, method.name, method.desc);
        }
        if (usage.getOpcode() >= 172 && usage.getOpcode() <= 177) {
            ConstantGroup group = this.grouper.getMethodReturnGroup(methodOwner, enclosingMethod.name, enclosingMethod.desc);
            if (group != null) {
                return group;
            }
            List<LambdaUsage> lambdaUsages = context.lambdaUsages.get(ConstantUninliner.getMethodKey(enclosingMethod));
            if (lambdaUsages != null) {
                for (LambdaUsage lambdaUsage : lambdaUsages) {
                    String samDesc;
                    String samName;
                    String samOwner = Type.getReturnType(lambdaUsage.indy.desc).getInternalName();
                    ConstantGroup g2 = this.grouper.getMethodReturnGroup(samOwner, samName = lambdaUsage.indy.name, samDesc = ((Type)lambdaUsage.indy.bsmArgs[0]).getDescriptor());
                    if (g2 == null) continue;
                    if (group != null && !g2.getName().equals(group.getName())) {
                        this.warnGroupConflict(g2, group, methodOwner, enclosingMethod);
                        return null;
                    }
                    group = g2;
                }
                return group;
            }
        }
        return null;
    }

    private boolean isAssigningToConstant(AbstractInsnNode insn) {
        AbstractInsnNode nextInsn = AbstractInsnNodes.nextInstruction(insn);
        if (nextInsn == null) {
            return false;
        }
        if (nextInsn.getOpcode() != 181 && nextInsn.getOpcode() != 179) {
            return false;
        }
        FieldInsnNode fieldInsn = (FieldInsnNode)nextInsn;
        IConstantResolver.ResolvedConstant resolvedConstant = this.constantResolver.resolveConstant(fieldInsn.owner, fieldInsn.name);
        return resolvedConstant != null && fieldInsn.desc.equals(resolvedConstant.type().getDescriptor());
    }

    private Map<String, List<LambdaUsage>> indexLambdaUsages(ClassNode classNode) {
        try {
            HashSet<String> syntheticMethods = new HashSet<String>();
            for (MethodNode method : classNode.methods) {
                if ((method.access & 0x1000) == 0) continue;
                syntheticMethods.add(ConstantUninliner.getMethodKey(method));
            }
            HashMap<String, List<LambdaUsage>> lambdaUsages = new HashMap<String, List<LambdaUsage>>();
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode insn : method.instructions) {
                    if (!(insn instanceof InvokeDynamicInsnNode)) continue;
                    InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                    if (!"java/lang/invoke/LambdaMetafactory".equals(indy.bsm.getOwner())) continue;
                    Handle lambdaMethod = (Handle)indy.bsmArgs[1];
                    String lambdaKey = ConstantUninliner.getMethodKey(lambdaMethod);
                    if (!lambdaMethod.getOwner().equals(classNode.name) || !syntheticMethods.contains(lambdaKey)) continue;
                    lambdaUsages.computeIfAbsent(lambdaKey, k -> new ArrayList(1)).add(new LambdaUsage(method, indy));
                }
            }
            return lambdaUsages;
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, "Error processing lambda usages for class " + classNode.name, e);
            return Map.of();
        }
    }

    private static boolean isStaticLambdaInvocation(InvokeDynamicInsnNode insn) {
        int kind = ((Handle)insn.bsmArgs[1]).getTag();
        return kind == 2 || kind == 4 || kind == 6 || kind == 8;
    }

    private static String getMethodKey(MethodNode method) {
        return method.name + method.desc;
    }

    private static String getMethodKey(Handle handle) {
        return handle.getName() + handle.getDesc();
    }

    private void warnGroupConflict(ConstantGroup group1, ConstantGroup group2, String methodOwner, MethodNode enclosingMethod) {
        this.logger.log(Level.WARNING, () -> String.format("Conflicting groups %s and %s competing for the same constant in method %s.%s%s", group1.getName(), group2.getName(), methodOwner, enclosingMethod.name, enclosingMethod.desc));
    }

    public static final class Builder {
        @Nullable
        private Logger logger;
        @Nullable
        private IConstantGrouper grouper;
        @Nullable
        private IClassResolver classResolver;
        @Nullable
        private IConstantResolver constantResolver;
        @Nullable
        private IInheritanceChecker inheritanceChecker;

        private Builder() {
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder grouper(IConstantGrouper grouper) {
            this.grouper = grouper;
            return this;
        }

        public Builder classResolver(IClassResolver classResolver) {
            this.classResolver = classResolver;
            return this;
        }

        public Builder constantResolver(IConstantResolver constantResolver) {
            this.constantResolver = constantResolver;
            return this;
        }

        public Builder inheritanceChecker(IInheritanceChecker inheritanceChecker) {
            this.inheritanceChecker = inheritanceChecker;
            return this;
        }

        public ConstantUninliner build() {
            Objects.requireNonNull(this.grouper, "Must add grouper to builder");
            Objects.requireNonNull(this.classResolver, "Must add classResolver to builder");
            if (this.logger == null) {
                this.logger = Logger.getLogger("unpick");
            }
            if (this.constantResolver == null) {
                this.constantResolver = this.classResolver.asConstantResolver();
            }
            if (this.inheritanceChecker == null) {
                this.inheritanceChecker = this.classResolver.asInheritanceChecker();
            }
            return new ConstantUninliner(this.logger, this.grouper, this.classResolver, this.constantResolver, this.inheritanceChecker);
        }
    }

    private record MethodTransformContext(Map<String, MethodNode> methods, Map<String, Frame<UnpickValue>[]> frames, Map<String, List<LambdaUsage>> lambdaUsages, Set<String> checkedMethods) {
    }

    private record LambdaUsage(MethodNode method, InvokeDynamicInsnNode indy) {
    }
}

