/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.Reference;

final class ImmutableBouncingTargetMetadata
implements BouncingTargetMetadata {
    private final Reference target;
    private final Reference owner;

    public ImmutableBouncingTargetMetadata(Reference target, Reference owner) {
        this.target = target;
        this.owner = owner;
    }

    @Override
    public Optional<Reference> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public Optional<Reference> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public @NonNull BouncingTargetMetadata toImmutable() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableBouncingTargetMetadata)) {
            return false;
        }
        ImmutableBouncingTargetMetadata that = (ImmutableBouncingTargetMetadata)o;
        if (this.getTarget().isPresent() ? !this.getTarget().equals(that.getTarget()) : that.getTarget().isPresent()) {
            return false;
        }
        return this.getOwner().isPresent() ? this.getOwner().equals(that.getOwner()) : !that.getOwner().isPresent();
    }

    public int hashCode() {
        int result = this.getTarget().isPresent() ? this.getTarget().hashCode() : 0;
        result = 31 * result + (this.getOwner().isPresent() ? this.getOwner().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ImmutableBouncingTargetMetadata{target=" + this.target + ", owner=" + this.owner + '}';
    }
}

