/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import java.util.EnumSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.ImmutableFieldMetadata;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;
import org.parchmentmc.feather.util.AccessFlag;

public final class FieldMetadataBuilder
implements FieldMetadata {
    private Named owner = Named.empty();
    private Named name = Named.empty();
    private int securitySpecification = 0;
    private Named descriptor = Named.empty();
    private Named signature = Named.empty();

    private FieldMetadataBuilder() {
    }

    public static FieldMetadataBuilder create() {
        return new FieldMetadataBuilder();
    }

    public static FieldMetadataBuilder create(FieldMetadata target) {
        if (target == null) {
            return FieldMetadataBuilder.create();
        }
        return FieldMetadataBuilder.create().withOwner(target.getOwner()).withName(target.getName()).withSecuritySpecification(target.getSecuritySpecification()).withDescriptor(target.getDescriptor()).withSignature(target.getSignature());
    }

    public FieldMetadataBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    public FieldMetadataBuilder withName(Named name) {
        this.name = name;
        return this;
    }

    public FieldMetadataBuilder withSecuritySpecification(int securitySpecification) {
        this.securitySpecification = securitySpecification;
        return this;
    }

    public FieldMetadataBuilder withDescriptor(Named descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public FieldMetadataBuilder withSignature(Named signature) {
        this.signature = signature;
        return this;
    }

    public FieldMetadataBuilder merge(FieldMetadata source) {
        if (source == null) {
            return this;
        }
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.name = NamedBuilder.create(this.name).merge(source.getName()).build();
        EnumSet<AccessFlag> thisAccessFlags = AccessFlag.getAccessFlags(this.securitySpecification);
        EnumSet<AccessFlag> sourceAccessFlags = AccessFlag.getAccessFlags(source.getSecuritySpecification());
        EnumSet<AccessFlag> mergedFlags = EnumSet.noneOf(AccessFlag.class);
        mergedFlags.addAll(thisAccessFlags);
        mergedFlags.addAll(sourceAccessFlags);
        this.securitySpecification = AccessFlag.toSecuritySpecification(mergedFlags);
        this.descriptor = NamedBuilder.create(this.descriptor).merge(source.getDescriptor()).build();
        this.signature = NamedBuilder.create(this.signature).merge(source.getSignature()).build();
        return this;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecification;
    }

    @Override
    public @NonNull Named getDescriptor() {
        return this.descriptor;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    public FieldMetadata build() {
        return new ImmutableFieldMetadata((Named)this.owner.toImmutable(), (Named)this.name.toImmutable(), this.securitySpecification, (Named)this.descriptor.toImmutable(), (Named)this.signature.toImmutable());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldMetadata)) {
            return false;
        }
        FieldMetadata that = (FieldMetadata)o;
        return this.getSecuritySpecification() == that.getSecuritySpecification() && Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName()) && this.getDescriptor().equals(that.getDescriptor()) && Objects.equals(this.getSignature(), that.getSignature());
    }

    public int hashCode() {
        return Objects.hash(this.getOwner(), this.getName(), this.getSecuritySpecification(), this.getDescriptor(), this.getSignature());
    }

    @Override
    public @NonNull FieldMetadata toImmutable() {
        return this.build();
    }
}

