/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.metadata.ReferenceBuilder;
import org.parchmentmc.feather.named.Named;

class ReferenceAdapter
extends TypeAdapter<Reference> {
    private final Gson gson;

    public ReferenceAdapter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void write(JsonWriter out, Reference value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), (Type)((Object)Named.class), out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), (Type)((Object)Named.class), out);
        out.name("descriptor");
        this.gson.toJson((Object)value.getDescriptor(), (Type)((Object)Named.class), out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), (Type)((Object)Named.class), out);
        out.endObject();
    }

    @Override
    public Reference read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        Named descriptor = Named.empty();
        Named signature = Named.empty();
        in.beginObject();
        block12: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block12;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block12;
                }
                case "descriptor": {
                    descriptor = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block12;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, (Type)((Object)Named.class));
                    continue block12;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Method reference name is not present");
        }
        if (owner.isEmpty()) {
            throw new JsonParseException("Method reference owner is not present");
        }
        if (descriptor.isEmpty()) {
            throw new JsonParseException("Method reference descriptor is not present");
        }
        return ReferenceBuilder.create().withOwner(owner).withName(name).withSignature(signature).withDescriptor(descriptor).build();
    }
}

