/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io.srg.tsrg;

import java.io.Writer;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.TextMappingsWriter;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;

public class TSrgWriter
extends TextMappingsWriter {
    public TSrgWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void write(MappingSet mappings) {
        mappings.getTopLevelClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
    }

    protected void writeClassMapping(ClassMapping<?, ?> mapping) {
        if (mapping.hasDeobfuscatedName() || mapping.getFieldsByName().values().stream().anyMatch(Mapping::hasDeobfuscatedName) || mapping.getMethodMappings().stream().anyMatch(MethodMapping::hasMappings)) {
            this.writer.println(String.format("%s %s", mapping.getFullObfuscatedName(), mapping.getFullDeobfuscatedName()));
        }
        mapping.getFieldsByName().values().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getFieldMappingComparator()).forEach(this::writeFieldMapping);
        mapping.getMethodMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getMethodMappingComparator()).forEach(this::writeMethodMapping);
        mapping.getInnerClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
    }

    protected void writeFieldMapping(FieldMapping mapping) {
        this.writer.println(String.format("\t%s %s", mapping.getObfuscatedName(), mapping.getDeobfuscatedName()));
    }

    protected void writeMethodMapping(MethodMapping mapping) {
        this.writer.println(String.format("\t%s %s %s", mapping.getObfuscatedName(), mapping.getObfuscatedDescriptor(), mapping.getDeobfuscatedName()));
    }
}

