/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.util;

import io.papermc.codebook.exceptions.UnexpectedException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IOUtil {
    private IOUtil() {
    }

    public static Path createTempDir(String prefix) {
        try {
            return IOUtil.absolutePath(Files.createTempDirectory(Path.of(".", new String[0]), prefix, new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to create temporary directory", e);
        }
    }

    public static Path absolutePath(Path path) {
        return path.toAbsolutePath().normalize();
    }

    public static String absolutePathString(Path path) {
        return IOUtil.absolutePath(path).toString();
    }

    public static void deleteIfExists(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to delete file " + String.valueOf(file), e);
        }
    }

    public static void createDirectories(@Nullable Path file) {
        if (file == null) {
            return;
        }
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to create directory " + String.valueOf(file.getParent()), e);
        }
    }

    public static void createParentDirectories(Path file) {
        IOUtil.createDirectories(file.getParent());
    }

    public static void copy(Path in, Path out) {
        try {
            Files.copy(in, out, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to copy file from " + String.valueOf(in) + " to " + String.valueOf(out), e);
        }
    }

    public static void move(Path source, Path dest) {
        try {
            Files.move(source, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to move file from " + String.valueOf(source) + " to " + String.valueOf(dest), e);
        }
    }

    public static void deleteRecursively(Path dir) {
        ArrayDeque files = new ArrayDeque();
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            files = stream.collect(Collectors.toCollection(ArrayDeque::new));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        files.descendingIterator().forEachRemaining(IOUtil::deleteIfExists);
    }
}

