/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.report;

import com.google.inject.AbstractModule;
import io.papermc.codebook.report.ReportType;
import io.papermc.codebook.report.type.MissingMethodLvtSuggestion;
import io.papermc.codebook.report.type.MissingMethodParam;
import io.papermc.codebook.report.type.Report;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Reports
extends AbstractModule {
    public static final Reports NOOP = new Reports(null, Set.of()){

        @Override
        public void generateReports() {
        }

        @Override
        protected void configure() {
        }
    };
    private final Path reportsDir;
    private final Set<ReportType> typesToGenerate;
    private final Map<ReportType, Report> reports;

    public Reports(Path reportsDir, Set<ReportType> typesToGenerate) {
        this.reportsDir = reportsDir;
        this.typesToGenerate = typesToGenerate;
        this.reports = Map.of(ReportType.MISSING_METHOD_LVT_SUGGESTION, new MissingMethodLvtSuggestion(), ReportType.MISSING_METHOD_PARAM, new MissingMethodParam());
    }

    public void generateReports() throws IOException {
        Files.createDirectories(this.reportsDir, new FileAttribute[0]);
        for (Map.Entry<ReportType, Report> entry : this.reports.entrySet()) {
            if (!this.typesToGenerate.contains((Object)entry.getKey())) continue;
            Path reportPath = this.reportsDir.resolve(entry.getKey().name().toLowerCase(Locale.ENGLISH) + ".txt");
            Files.writeString(reportPath, (CharSequence)entry.getValue().generate(), new OpenOption[0]);
        }
    }

    public boolean shouldGenerate(ReportType reportType) {
        return this.typesToGenerate.contains((Object)reportType);
    }

    @Override
    protected void configure() {
        this.reports.values().forEach(this::bindReport);
    }

    private <R extends Report> void bindReport(R report) {
        this.bind(report.getClass()).toInstance(report);
    }
}

