/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import daomephsta.unpick.api.ConstantUninliner;
import daomephsta.unpick.api.classresolvers.ClassResolvers;
import daomephsta.unpick.api.classresolvers.IClassResolver;
import daomephsta.unpick.api.constantgroupers.ConstantGroupers;
import daomephsta.unpick.constantmappers.datadriven.parser.v3.UnpickV3Reader;
import daomephsta.unpick.constantmappers.datadriven.tree.ForwardingUnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.GroupDefinition;
import daomephsta.unpick.constantmappers.datadriven.tree.UnpickV3Visitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.Expression;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.ExpressionVisitor;
import daomephsta.unpick.constantmappers.datadriven.tree.expr.FieldExpression;
import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.data.ClassData;
import io.papermc.codebook.pages.AsmProcessorPage;
import io.papermc.codebook.pages.CodeBookPage;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.ClassNode;

public final class UnpickPage
extends AsmProcessorPage {
    private final List<Path> classpath;
    private final @Nullable Path unpickDefinitions;
    private @MonotonicNonNull ConstantUninliner uninliner;

    @Inject
    public UnpickPage(@CodeBookPage.Hypo HypoContext context, @CodeBookPage.ClasspathJars List<Path> classpath, @CodeBookPage.UnpickDefinitions @Nullable Path unpickDefinitions) {
        super(context);
        this.classpath = classpath;
        this.unpickDefinitions = unpickDefinitions;
    }

    @Override
    public void exec() {
        block21: {
            boolean isZip;
            if (this.unpickDefinitions == null) {
                return;
            }
            try (ZipFile zf = new ZipFile(this.unpickDefinitions.toFile());){
                isZip = true;
            }
            catch (ZipException e) {
                isZip = false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ArrayList<ZipFile> zips = new ArrayList<ZipFile>();
            if (isZip) {
                try (FileSystem definitionsFs = FileSystems.newFileSystem(this.unpickDefinitions);){
                    Path definitionsPath = definitionsFs.getPath("extras/definitions.unpick", new String[0]);
                    this.unpick(definitionsPath, zips);
                    break block21;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                this.unpick(this.unpickDefinitions, zips);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpick(Path definitionsPath, List<ZipFile> zips) throws IOException {
        IClassResolver classResolver = new IClassResolver(){

            @Override
            public @Nullable ClassNode resolveClass(String internalName) {
                try {
                    @Nullable ClassData cls = UnpickPage.this.context.getContextProvider().findClass(internalName);
                    if (cls instanceof AsmClassData) {
                        AsmClassData asmClassData = (AsmClassData)cls;
                        return asmClassData.getNode();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return null;
            }
        };
        try (BufferedReader definitionsReader = Files.newBufferedReader(definitionsPath);){
            for (Path classpathJar : this.classpath) {
                ZipFile zip = new ZipFile(classpathJar.toFile());
                zips.add(zip);
                classResolver = classResolver.chain(ClassResolvers.jar(zip));
            }
            classResolver = classResolver.chain(ClassResolvers.classpath());
            this.uninliner = ConstantUninliner.builder().grouper(ConstantGroupers.dataDriven().classResolver(classResolver).mappingSource(visitor -> {
                try {
                    new UnpickV3Reader(definitionsReader).accept(new ForwardingUnpickV3Visitor((UnpickV3Visitor)visitor){

                        @Override
                        public void visitGroupDefinition(GroupDefinition groupDefinition) {
                            final ArrayList<Expression> constants = new ArrayList<Expression>(groupDefinition.constants());
                            for (final Expression constant : groupDefinition.constants()) {
                                constant.accept(new ExpressionVisitor(){

                                    @Override
                                    public void visitFieldExpression(FieldExpression fieldExpression) {
                                        try {
                                            @Nullable ClassData clsData = UnpickPage.this.context.getContextProvider().findClass(fieldExpression.className);
                                            if (clsData == null) {
                                                constants.remove(constant);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new UncheckedIOException(e);
                                        }
                                    }
                                });
                            }
                            if (!constants.isEmpty()) {
                                super.visitGroupDefinition(GroupDefinition.Builder.from(groupDefinition).setConstants(constants).build());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).build()).classResolver(classResolver).build();
            this.processClasses();
        }
        finally {
            for (ZipFile zip : zips) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void processClass(AsmClassData classData) {
        if (this.uninliner == null) {
            return;
        }
        this.uninliner.transform(classData.getNode());
    }
}

