/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.util.IOUtil;
import io.papermc.codebook.util.JarRunner;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.List;

public final class RemapJarPage
extends CodeBookPage {
    private final List<Path> remapper;
    private final Path inputJar;
    private final List<Path> classpath;
    private final Path tempDir;
    private final Path mojangMappings;

    @Inject
    public RemapJarPage(@CodeBookPage.RemapperJar List<Path> remapper, @CodeBookPage.InputJar Path inputJar, @CodeBookPage.ClasspathJars List<Path> classpath, @CodeBookPage.TempDir Path tempDir, @CodeBookPage.MojangMappings Path mojangMappings) {
        this.remapper = remapper;
        this.inputJar = inputJar;
        this.classpath = classpath;
        this.tempDir = tempDir;
        this.mojangMappings = mojangMappings;
    }

    @Override
    public void exec() {
        Path remapped = this.tempDir.resolve("remapped.jar");
        JarRunner.of("AutoRenamingTool", this.remapper).withArgs("--input=" + IOUtil.absolutePathString(this.inputJar), "--output=" + IOUtil.absolutePathString(remapped), "--map=" + IOUtil.absolutePathString(this.mojangMappings), "--reverse").withArgs(this.classpath.stream().map(IOUtil::absolutePathString).map(s2 -> "--lib=" + s2).toList()).withArgs("--src-fix", "--strip-sigs", "--disable-abstract-param").run();
        this.bind(CodeBookPage.InputJar.KEY).to(remapped);
    }
}

