/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.pages;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.pages.CodeBookPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AsmProcessorPage
extends CodeBookPage {
    protected final HypoContext context;

    protected AsmProcessorPage(HypoContext context) {
        this.context = context;
    }

    @Override
    public void exec() {
        this.processClasses();
    }

    protected void processClasses() {
        ArrayList tasks = new ArrayList();
        for (ClassData classData : this.context.getProvider().allClasses()) {
            Future<?> task = this.context.getExecutor().submit(() -> {
                try {
                    this.processClass((AsmClassData)classData);
                }
                catch (Exception e) {
                    throw HypoModelUtil.rethrow(e);
                }
            });
            tasks.add(task);
        }
        try {
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            throw new UnexpectedException("Failed to process classes", e.getCause());
        }
        catch (InterruptedException e) {
            throw new UnexpectedException("Class processing interrupted", e);
        }
    }

    protected abstract void processClass(AsmClassData var1) throws IOException;
}

