/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion.numbers;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import io.papermc.codebook.lvt.suggestion.numbers.RandomUtil;
import jakarta.inject.Inject;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RandomSourceSuggester
implements LvtSuggester {
    static final JvmType RANDOM_SOURCE_TYPE = new ClassType("net/minecraft/util/RandomSource");
    private final @Nullable ClassData randomSourceClass;

    @Inject
    RandomSourceSuggester(HypoContext hypoContext) throws IOException {
        this.randomSourceClass = hypoContext.getContextProvider().findClass(RANDOM_SOURCE_TYPE);
        if (this.randomSourceClass == null) {
            System.err.println("Failed to find RandomSource class, disabling RandomSourceSuggester");
        }
    }

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) {
        if (this.randomSourceClass == null) {
            return null;
        }
        String methodName = call.data().name();
        ClassData ownerClass = insn.owner();
        if (ownerClass.doesExtendOrImplement(this.randomSourceClass)) {
            ownerClass = this.randomSourceClass;
        }
        if (!ownerClass.equals(this.randomSourceClass)) {
            return null;
        }
        if (!methodName.startsWith("next") || "next".equals(methodName)) {
            return null;
        }
        return RandomUtil.createNextRandomName(call.data());
    }
}

