/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.lvt.suggestion.numbers;

import dev.denwav.hypo.model.data.types.JvmType;
import io.papermc.codebook.lvt.LvtUtil;
import io.papermc.codebook.lvt.suggestion.LvtSuggester;
import io.papermc.codebook.lvt.suggestion.context.ContainerContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodCallContext;
import io.papermc.codebook.lvt.suggestion.context.method.MethodInsnContext;
import io.papermc.codebook.lvt.suggestion.numbers.RandomSourceSuggester;
import io.papermc.codebook.lvt.suggestion.numbers.RandomUtil;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MthRandomSuggester
implements LvtSuggester {
    static final String MTH_NAME = "net/minecraft/util/Mth";

    @Override
    public @Nullable String suggestFromMethod(MethodCallContext call, MethodInsnContext insn, ContainerContext container) {
        String methodName = call.data().name();
        if (!insn.ownerEqualTo(MTH_NAME)) {
            return null;
        }
        if (!LvtUtil.hasPrefix(methodName, "next")) {
            return null;
        }
        List<JvmType> params = call.data().params();
        if (params.isEmpty() || !params.get(0).equals(RandomSourceSuggester.RANDOM_SOURCE_TYPE)) {
            return null;
        }
        return RandomUtil.createNextRandomName(call.data());
    }
}

