/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook.config;

import io.papermc.codebook.config.CodeBookCoordsResourceBuilder;
import io.papermc.codebook.config.CodeBookResource;
import io.papermc.codebook.exceptions.UserErrorException;
import io.papermc.codebook.util.Downloader;
import java.net.URI;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CodeBookCoordsResource(@NotNull String coords, @org.checkerframework.checker.nullness.qual.Nullable @Nullable String classifier, @org.checkerframework.checker.nullness.qual.Nullable @Nullable String extension, @NotNull String mavenBaseUrl) implements CodeBookResource
{
    public static CodeBookCoordsResourceBuilder builder() {
        return CodeBookCoordsResourceBuilder.builder();
    }

    @Override
    public Path resolveResourceFile(Path tempDir) {
        this.verifyMavenCoords(this.coords);
        URI uri = Downloader.getDownloadUri(this.mavenBaseUrl, this.getFullCoords());
        String[] parts = this.coords.split(":");
        StringBuilder sb = new StringBuilder();
        sb.append(parts[1]).append('-').append(parts[2]);
        if (this.classifier != null) {
            sb.append('-').append(this.classifier);
        }
        sb.append('.').append(this.getExtension());
        Path outputFile = tempDir.resolve(sb.toString());
        Downloader.downloadFile(uri, outputFile);
        return outputFile;
    }

    private void verifyMavenCoords(String text) {
        if (text.split(":").length == 4) {
            throw new UserErrorException("Do not provide a classifier when specifying Maven coordinates.");
        }
    }

    private String getExtension() {
        return this.extension == null ? "jar" : this.extension;
    }

    private String getFullCoords() {
        StringBuilder sb = new StringBuilder(this.coords);
        if (this.classifier != null) {
            sb.append(':').append(this.classifier);
        }
        if (this.extension != null) {
            sb.append('@').append(this.extension);
        }
        return sb.toString();
    }
}

