/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.codebook;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Providers;
import dev.denwav.hypo.asm.AsmOutputWriter;
import dev.denwav.hypo.core.HypoConfig;
import dev.denwav.hypo.core.HypoContext;
import io.papermc.codebook.config.CodeBookClasspathResource;
import io.papermc.codebook.config.CodeBookContext;
import io.papermc.codebook.config.CodeBookInput;
import io.papermc.codebook.config.CodeBookJarInput;
import io.papermc.codebook.config.CodeBookRemapper;
import io.papermc.codebook.config.CodeBookResource;
import io.papermc.codebook.exceptions.UnexpectedException;
import io.papermc.codebook.exceptions.UserErrorException;
import io.papermc.codebook.pages.CodeBookPage;
import io.papermc.codebook.pages.ExtractVanillaJarPage;
import io.papermc.codebook.pages.FixJarPage;
import io.papermc.codebook.pages.InspectJarPage;
import io.papermc.codebook.pages.RemapJarPage;
import io.papermc.codebook.pages.RemapLvtPage;
import io.papermc.codebook.pages.UnpickPage;
import io.papermc.codebook.report.Reports;
import io.papermc.codebook.util.IOUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CodeBook {
    private final CodeBookContext ctx;

    public CodeBook(CodeBookContext ctx) {
        this.ctx = ctx;
    }

    public void exec() {
        if (this.ctx.tempDir() == null) {
            Path tempDir = IOUtil.createTempDir(".tmp_codebook");
            try {
                this.exec(tempDir);
            }
            finally {
                IOUtil.deleteRecursively(tempDir);
            }
        } else {
            this.exec(this.ctx.tempDir());
        }
    }

    private void exec(Path tempDir) {
        Path resultJar;
        this.deleteOutputFile();
        List<Class<RemapLvtPage>> book = List.of(ExtractVanillaJarPage.class, RemapJarPage.class, InspectJarPage.class, UnpickPage.class, FixJarPage.class, RemapLvtPage.class);
        Module module = this.createInitialModule(tempDir);
        for (Class<RemapLvtPage> page : book) {
            module = ((CodeBookPage)CodeBook.injector(module).getInstance(page)).exec(module);
        }
        HypoContext context = CodeBook.injector(module).getInstance(CodeBookPage.Hypo.KEY);
        try (HypoContext hypoContext = context;){
            resultJar = tempDir.resolve("final_output.jar");
            AsmOutputWriter.to(resultJar).write(context);
        }
        catch (Exception e) {
            throw new UnexpectedException("Failed to write output file", e);
        }
        IOUtil.move(resultJar, this.ctx.outputJar());
        if (this.ctx.reports() != null) {
            try {
                this.ctx.reports().generateReports();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Injector injector(Module module) {
        return Guice.createInjector(module);
    }

    private Module createInitialModule(final Path tempDir) {
        List<Path> remapperJars;
        List<Path> classpathJars;
        @Nullable CodeBookResource mappings = this.ctx.input().resolveMappings(this.ctx, tempDir);
        if (mappings == null) {
            throw new IllegalStateException("No mappings file could be determined for the given configuration");
        }
        final Path inputJar = this.ctx.input().resolveInputFile(tempDir);
        CodeBookInput codeBookInput = this.ctx.input();
        if (codeBookInput instanceof CodeBookJarInput) {
            CodeBookJarInput input = (CodeBookJarInput)codeBookInput;
            classpathJars = input.classpathJars();
        } else {
            classpathJars = null;
        }
        final Path mappingsFile = mappings.resolveResourceFile(tempDir);
        final Path paramMappingsFile = this.ctx.paramMappings() != null ? this.ctx.paramMappings().resolveResourceFile(tempDir) : null;
        CodeBookRemapper codeBookRemapper = this.ctx.remapperJar();
        if (codeBookRemapper instanceof CodeBookResource) {
            CodeBookResource resource = (CodeBookResource)codeBookRemapper;
            remapperJars = List.of(resource.resolveResourceFile(tempDir));
        } else {
            codeBookRemapper = this.ctx.remapperJar();
            if (codeBookRemapper instanceof CodeBookClasspathResource) {
                CodeBookClasspathResource resource = (CodeBookClasspathResource)codeBookRemapper;
                remapperJars = resource.jars();
            } else {
                throw new LinkageError();
            }
        }
        final Path unpickDefinitions = this.ctx.unpickDefinitions() != null ? (this.ctx.unpickDefinitions().equals(this.ctx.paramMappings()) ? paramMappingsFile : this.ctx.unpickDefinitions().resolveResourceFile(tempDir)) : null;
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(CodeBookPage.Context.KEY).toInstance(CodeBook.this.ctx);
                this.bind(CodeBookPage.InputJar.KEY).toInstance(inputJar);
                if (classpathJars != null) {
                    this.bind(CodeBookPage.ClasspathJars.KEY).toInstance(classpathJars);
                } else {
                    this.bind(CodeBookPage.ClasspathJars.KEY).toProvider(Providers.of(null));
                }
                this.bind(CodeBookPage.TempDir.KEY).toInstance(tempDir);
                this.bind(CodeBookPage.MojangMappings.PATH_KEY).toInstance(mappingsFile);
                this.bind(CodeBookPage.ParamMappings.PATH_KEY).toProvider(Providers.of(paramMappingsFile));
                this.bind(CodeBookPage.RemapperJar.KEY).toInstance(remapperJars);
                if (unpickDefinitions != null) {
                    this.bind(CodeBookPage.UnpickDefinitions.KEY).toInstance(unpickDefinitions);
                } else {
                    this.bind(CodeBookPage.UnpickDefinitions.KEY).toProvider(Providers.of(null));
                }
                if (CodeBook.this.ctx.reports() != null) {
                    this.bind(CodeBookPage.Report.KEY).toInstance(CodeBook.this.ctx.reports());
                    this.install(CodeBook.this.ctx.reports());
                } else {
                    this.bind(CodeBookPage.Report.KEY).toInstance(Reports.NOOP);
                    this.install(Reports.NOOP);
                }
                if (CodeBook.this.ctx.hypoConfig() != null) {
                    this.bind(CodeBookPage.Hypo.CONFIG_KEY).toInstance(CodeBook.this.ctx.hypoConfig());
                } else {
                    this.bind(CodeBookPage.Hypo.CONFIG_KEY).toInstance(HypoConfig.builder().build());
                }
            }
        };
    }

    private void deleteOutputFile() {
        if (Files.isRegularFile(this.ctx.outputJar(), new LinkOption[0])) {
            if (!this.ctx.overwrite()) {
                throw new UserErrorException("Cannot write output file " + String.valueOf(this.ctx.outputJar()) + " as it already exists, and --force was not specified.");
            }
            IOUtil.deleteIfExists(this.ctx.outputJar());
        }
    }
}

