/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model.data.types;

import com.google.errorprone.annotations.Immutable;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import org.jetbrains.annotations.NotNull;

@Immutable
public enum PrimitiveType implements JvmType
{
    CHAR("char", "C", "java/lang/Character"),
    BYTE("byte", "B", "java/lang/Byte"),
    SHORT("short", "S", "java/lang/Short"),
    INT("int", "I", "java/lang/Integer"),
    LONG("long", "J", "java/lang/Long"),
    FLOAT("float", "F", "java/lang/Float"),
    DOUBLE("double", "D", "java/lang/Double"),
    BOOLEAN("boolean", "Z", "java/lang/Boolean"),
    VOID("void", "V", "java/lang/Void");

    @NotNull
    private final String readableName;
    @NotNull
    private final String internalName;
    @NotNull
    private final ClassType wrapperType;

    private PrimitiveType(@NotNull String readableName, String internalName, String wrapperType) {
        this.readableName = readableName;
        this.internalName = internalName;
        this.wrapperType = new ClassType(wrapperType);
    }

    @NotNull
    public ClassType toWrapperType() {
        return this.wrapperType;
    }

    @Override
    public void asReadableName(@NotNull StringBuilder sb) {
        sb.append(this.readableName);
    }

    @Override
    public void asInternalName(@NotNull StringBuilder sb) {
        sb.append(this.internalName);
    }

    @NotNull
    public static PrimitiveType fromChar(char c) {
        for (PrimitiveType v : PrimitiveType.values()) {
            if (v.internalName.charAt(0) != c) continue;
            return v;
        }
        throw new IllegalStateException("Unknown type: " + c);
    }

    public String toString() {
        return this.asReadableName();
    }
}

