/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model.data.types;

import com.google.errorprone.annotations.Immutable;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.types.JvmType;
import dev.denwav.hypo.model.data.types.PrimitiveType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class ClassType
implements JvmType {
    @NotNull
    private final String className;

    public ClassType(@NotNull String className) {
        this.className = HypoModelUtil.normalizedClassName(className);
    }

    @Override
    public void asReadableName(@NotNull StringBuilder sb) {
        sb.append(this.className.replace('/', '.'));
    }

    @Override
    public void asInternalName(@NotNull StringBuilder sb) {
        sb.append('L').append(this.className).append(';');
    }

    @Nullable
    public PrimitiveType toPrimitiveType() {
        for (PrimitiveType value : PrimitiveType.values()) {
            if (!value.toWrapperType().equals(this)) continue;
            return value;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassType)) {
            return false;
        }
        ClassType classType = (ClassType)o;
        return this.className.equals(classType.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }

    public String toString() {
        return this.asReadableName();
    }
}

