/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model.data;

import dev.denwav.hypo.model.data.AbstractClassData;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.LazyValue;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.Visibility;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyClassData
extends AbstractClassData {
    @NotNull
    private final LazyValue<String, ?> name = LazyValue.of(this::computeName);
    @NotNull
    private final LazyValue<ClassData, IOException> outerClass = LazyValue.of(this::computeOuterClass);
    private final LazyValue<Boolean, ?> staticInnerClass = LazyValue.of(this::computeStaticInnerClass);
    private final LazyValue<Boolean, ?> isFinal = LazyValue.of(this::computeIsFinal);
    private final LazyValue<Boolean, ?> isSynthetic = LazyValue.of(this::computeIsSynthetic);
    private final LazyValue<Boolean, ?> isSealed = LazyValue.of(this::computeIsSealed);
    private final LazyValue<List<ClassData>, IOException> permittedClasses = LazyValue.of(this::computePermittedClasses);
    private final LazyValue<List<FieldData>, ?> recordComponents = LazyValue.of(this::computeRecordComponents);
    @NotNull
    private final LazyValue<EnumSet<ClassKind>, ?> kinds = LazyValue.of(this::computeClassKinds);
    @NotNull
    private final @NotNull LazyValue<@NotNull Visibility, ?> visibility = LazyValue.of(this::computeVisibility);
    @NotNull
    private final LazyValue<ClassData, IOException> superClass = LazyValue.of(this::computeSuperClass);
    @NotNull
    private final LazyValue<List<ClassData>, IOException> interfaces = LazyValue.of(this::computeInterfaces);
    @NotNull
    private final LazyValue<List<FieldData>, ?> fields = LazyValue.of(this::computeFields);
    @NotNull
    private final LazyValue<List<MethodData>, ?> methods = LazyValue.of(this::computeMethods);

    @NotNull
    public abstract String computeName();

    @Nullable
    public abstract ClassData computeOuterClass() throws IOException;

    public abstract boolean computeStaticInnerClass();

    public abstract boolean computeIsFinal();

    public abstract boolean computeIsSynthetic();

    public abstract boolean computeIsSealed();

    @Nullable
    public abstract List<ClassData> computePermittedClasses() throws IOException;

    public abstract @Nullable List<@NotNull FieldData> computeRecordComponents();

    @Deprecated
    @NotNull
    public ClassKind computeClassKind() {
        throw new IllegalStateException();
    }

    @NotNull
    public abstract EnumSet<ClassKind> computeClassKinds();

    @NotNull
    public abstract Visibility computeVisibility();

    @Nullable
    public abstract ClassData computeSuperClass() throws IOException;

    @NotNull
    public abstract List<ClassData> computeInterfaces() throws IOException;

    @NotNull
    public abstract List<FieldData> computeFields();

    @NotNull
    public abstract List<MethodData> computeMethods();

    @Override
    @NotNull
    public String name() {
        return this.name.getNotNull();
    }

    @Override
    @Nullable
    public ClassData outerClass() throws IOException {
        return this.outerClass.getOrThrow();
    }

    @Override
    public boolean isStaticInnerClass() {
        return this.staticInnerClass.getNotNull();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal.getNotNull();
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic.getNotNull();
    }

    @Override
    public boolean isSealed() {
        return this.isSealed.getNotNull();
    }

    @Override
    @Nullable
    public List<ClassData> permittedClasses() throws IOException {
        return this.permittedClasses.getOrThrow();
    }

    @Override
    public @Nullable List<@NotNull FieldData> recordComponents() {
        return this.recordComponents.get();
    }

    @Override
    @NotNull
    public EnumSet<ClassKind> kinds() {
        return this.kinds.getNotNull();
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return this.visibility.getNotNull();
    }

    @Override
    @Nullable
    public ClassData superClass() throws IOException {
        return this.superClass.getOrThrow();
    }

    @Override
    @NotNull
    public List<ClassData> interfaces() throws IOException {
        return this.interfaces.getOrThrowNotNull();
    }

    @Override
    @NotNull
    public List<FieldData> fields() {
        return this.fields.getNotNull();
    }

    @Override
    @NotNull
    public List<MethodData> methods() {
        return this.methods.getNotNull();
    }
}

