/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model;

import dev.denwav.hypo.model.ClassProviderRoot;
import dev.denwav.hypo.model.HypoModelUtil;
import java.io.IOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SystemClassProviderRootJdk9
implements ClassProviderRoot {
    @NotNull
    private final List<ModuleReader> readers;

    SystemClassProviderRootJdk9() throws IOException {
        Set<ModuleReference> refs = ModuleFinder.ofSystem().findAll();
        ModuleReader[] readers = new ModuleReader[refs.size()];
        int index = 0;
        for (ModuleReference ref : refs) {
            readers[index++] = ref.open();
        }
        this.readers = Arrays.asList(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte @Nullable [] getClassData(@NotNull String fileName) throws IOException {
        for (ModuleReader reader : this.readers) {
            ByteBuffer resource = reader.read(fileName).orElse(null);
            if (resource == null) continue;
            try {
                byte[] data = new byte[resource.remaining()];
                resource.get(data);
                byte[] byArray = data;
                return byArray;
            }
            finally {
                reader.release(resource);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends ClassProviderRoot.FileDataReference> getAllClasses() throws IOException {
        List refs = null;
        for (ModuleReader reader : this.readers) {
            List list = reader.list().filter(n -> n.endsWith(".class")).map(n -> new SystemFileDataReference((String)n, reader)).collect(Collectors.toList());
            if (refs == null) {
                refs = list;
                continue;
            }
            refs.addAll(list);
        }
        return refs == null ? Collections.emptyList() : refs;
    }

    @Override
    public void close() throws IOException {
        IOException thrown = null;
        for (ModuleReader reader : this.readers) {
            try {
                reader.close();
            }
            catch (IOException e) {
                thrown = HypoModelUtil.addSuppressed(thrown, e);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    static final class SystemFileDataReference
    implements ClassProviderRoot.FileDataReference {
        @NotNull
        private final String name;
        @NotNull
        private final ModuleReader reader;

        SystemFileDataReference(@NotNull String name, @NotNull ModuleReader reader) {
            this.name = name;
            this.reader = reader;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte @Nullable [] readData() throws IOException {
            ByteBuffer resource = this.reader.read(this.name).orElse(null);
            if (resource == null) {
                return null;
            }
            try {
                byte[] data = new byte[resource.remaining()];
                resource.get(data);
                byte[] byArray = data;
                return byArray;
            }
            finally {
                this.reader.release(resource);
            }
        }
    }
}

