/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model;

import dev.denwav.hypo.model.DirClassProviderRoot;
import dev.denwav.hypo.model.JarClassProviderRoot;
import dev.denwav.hypo.model.SystemClassProviderRoot;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClassProviderRoot
extends AutoCloseable {
    public byte @Nullable [] getClassData(@NotNull String var1) throws IOException;

    @NotNull
    public List<? extends FileDataReference> getAllClasses() throws IOException;

    @ApiStatus.Experimental
    @NotNull
    default public Stream<? extends FileDataReference> walkAllFiles() throws IOException {
        return Stream.of(new FileDataReference[0]);
    }

    @Override
    public void close() throws IOException;

    @NotNull
    public static ClassProviderRoot ofJdk() throws IOException {
        return SystemClassProviderRoot.newInstance();
    }

    @NotNull
    public static ClassProviderRoot fromDir(@NotNull Path path) {
        return new DirClassProviderRoot(path);
    }

    @NotNull
    public static @NotNull List<@NotNull ClassProviderRoot> fromDirs(Path ... paths) {
        ClassProviderRoot[] roots = new ClassProviderRoot[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            roots[i] = new DirClassProviderRoot(paths[i]);
        }
        return Arrays.asList(roots);
    }

    @NotNull
    public static ClassProviderRoot fromJar(@NotNull Path path) throws IOException {
        return new JarClassProviderRoot(path);
    }

    @NotNull
    public static @NotNull List<@NotNull ClassProviderRoot> fromJars(Path ... paths) throws IOException {
        ClassProviderRoot[] roots = new ClassProviderRoot[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            roots[i] = new JarClassProviderRoot(paths[i]);
        }
        return Arrays.asList(roots);
    }

    public static interface FileDataReference {
        @NotNull
        public String name();

        public byte @Nullable [] readData() throws IOException;
    }
}

