/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model;

import com.google.errorprone.annotations.ForOverride;
import dev.denwav.hypo.model.ClassDataDecorator;
import dev.denwav.hypo.model.ClassDataProvider;
import dev.denwav.hypo.model.ClassProviderRoot;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.Visibility;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClassDataProvider
implements ClassDataProvider {
    @NotNull
    private static final ClassData NULL_DATA = AbstractClassDataProvider.createNullData();
    @NotNull
    private final ConcurrentHashMap<String, ClassData> cache = new ConcurrentHashMap();
    @NotNull
    private final @NotNull List<@NotNull ClassProviderRoot> rootProviders;
    @Nullable
    private ClassDataDecorator decorator = null;
    private boolean isContextClassProvider = false;
    private boolean isRequireFullClasspath = false;

    protected AbstractClassDataProvider(@NotNull @NotNull List<@NotNull ClassProviderRoot> rootProviders) {
        this.rootProviders = rootProviders;
    }

    @Override
    public void setDecorator(@NotNull ClassDataDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    public boolean isContextClassProvider() {
        return this.isContextClassProvider;
    }

    @Override
    public void setContextClassProvider(boolean contextClassProvider) {
        this.isContextClassProvider = contextClassProvider;
    }

    @Override
    public boolean isRequireFullClasspath() {
        return this.isRequireFullClasspath;
    }

    @Override
    public void setRequireFullClasspath(boolean requireFullClasspath) {
        this.isRequireFullClasspath = requireFullClasspath;
    }

    @Override
    @Contract(value="null -> null")
    @Nullable
    public ClassData findClass(@Nullable String className) {
        if (className == null) {
            return null;
        }
        ClassData result = this.cache.computeIfAbsent(this.normalize(className), k -> {
            try {
                byte[] fileData = this.findFile(k + ".class");
                if (fileData == null) {
                    return NULL_DATA;
                }
                ClassData res = this.parseClassData(fileData);
                return res != null ? this.decorate(res) : NULL_DATA;
            }
            catch (IOException e) {
                throw HypoModelUtil.rethrow(e);
            }
        });
        return result != NULL_DATA ? result : null;
    }

    private byte @Nullable [] findFile(@NotNull String fileName) throws IOException {
        for (ClassProviderRoot rootProvider : this.rootProviders) {
            byte[] data = rootProvider.getClassData(fileName);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    @NotNull
    private String normalize(@NotNull String className) {
        String fullClassName = className.endsWith(".class") ? className.substring(0, className.length() - 6) : className;
        if ((fullClassName = HypoModelUtil.normalizedClassName(fullClassName)).startsWith("/")) {
            fullClassName = fullClassName.substring(1);
        }
        return fullClassName;
    }

    @Override
    @NotNull
    public Stream<ClassData> stream() throws IOException {
        return this.rootProviders.stream().flatMap(HypoModelUtil.wrapFunction(r -> r.getAllClasses().stream())).map(ref -> this.cache.computeIfAbsent(this.normalize(ref.name()), HypoModelUtil.wrapFunction(k -> {
            byte[] rawData = ref.readData();
            if (rawData == null) {
                return NULL_DATA;
            }
            ClassData result = this.parseClassData(rawData);
            return result != null ? this.decorate(result) : NULL_DATA;
        })));
    }

    @ForOverride
    @Nullable
    protected abstract ClassData parseClassData(byte @NotNull [] var1) throws IOException;

    @Contract(value="_ -> param1")
    @NotNull
    private ClassData decorate(@NotNull ClassData classData) {
        if (this.decorator == null) {
            throw new IllegalStateException("ClassData requested before decorating ClassDataProvider");
        }
        this.decorator.decorate(classData);
        classData.setContextClass(this.isContextClassProvider());
        classData.setRequireFullClasspath(this.isRequireFullClasspath());
        return classData;
    }

    @Override
    public void close() throws IOException {
        IOException thrown = null;
        for (ClassProviderRoot rootProvider : this.rootProviders) {
            try {
                rootProvider.close();
            }
            catch (IOException e) {
                if (thrown == null) {
                    thrown = e;
                    continue;
                }
                thrown.addSuppressed(e);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    @Override
    @NotNull
    public Collection<ClassProviderRoot> roots() {
        return this.rootProviders;
    }

    @NotNull
    private static ClassData createNullData() {
        return new ClassData(){

            @Override
            public void setProvider(@NotNull ClassDataProvider provider) {
                throw new IllegalStateException();
            }

            @Override
            public boolean isContextClass() {
                throw new IllegalStateException();
            }

            @Override
            public void setContextClass(boolean contextClass) {
                throw new IllegalStateException();
            }

            @Override
            public boolean isRequireFullClasspath() {
                throw new IllegalStateException();
            }

            @Override
            public void setRequireFullClasspath(boolean requireFullClasspath) {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public String name() {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public ClassData outerClass() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isStaticInnerClass() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isFinal() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isSynthetic() {
                throw new IllegalStateException();
            }

            @Override
            public boolean isSealed() {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public List<ClassData> permittedClasses() {
                throw new IllegalStateException();
            }

            @Override
            public @Nullable List<@NotNull FieldData> recordComponents() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public EnumSet<ClassKind> kinds() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public Visibility visibility() {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public ClassData superClass() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public List<ClassData> interfaces() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public List<FieldData> fields() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public List<MethodData> methods() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public @NotNull Set<@NotNull ClassData> childClasses() {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public @NotNull Set<@NotNull ClassData> innerClasses() {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public <T> T store(@NotNull HypoKey<T> key, @Nullable T t2) {
                throw new IllegalStateException();
            }

            @Override
            @NotNull
            public <T> T compute(@NotNull HypoKey<T> key, @NotNull Supplier<T> supplier) {
                throw new IllegalStateException();
            }

            @Override
            @Nullable
            public <T> T get(@NotNull HypoKey<T> key) {
                throw new IllegalStateException();
            }

            @Override
            public boolean contains(@NotNull HypoKey<?> key) {
                throw new IllegalStateException();
            }
        };
    }
}

