/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.SuperCall;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.changes.CopyConstructorMappingChange;
import dev.denwav.hypo.mappings.changes.CopyMethodMappingChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ConstructorData;
import dev.denwav.hypo.model.data.MethodData;
import java.util.List;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyMappingsDown
implements ChangeContributor {
    private final boolean stopOnChildMapping;

    private CopyMappingsDown(boolean stopOnChildMapping) {
        this.stopOnChildMapping = stopOnChildMapping;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyMappingsDown create() {
        return new CopyMappingsDown(false);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyMappingsDown createWithoutOverwrite() {
        return new CopyMappingsDown(true);
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null || classMapping == null) {
            return;
        }
        for (MethodData method : currentClass.methods()) {
            MethodMapping methodMapping = LorenzUtil.getMethodMapping(classMapping, method.name(), method.descriptorText());
            if (methodMapping == null) continue;
            if (!method.isConstructor()) {
                this.walkDown(method, methodMapping, registry);
                continue;
            }
            CopyMappingsDown.walkConstructor(method, methodMapping, registry, null);
        }
    }

    private void walkDown(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry) {
        for (MethodData childMethod : method.childMethods()) {
            this.setChangeAndWalkDown(childMethod, mapping, registry);
        }
        MethodData syntheticTarget = method.get(HypoHydration.SYNTHETIC_TARGET);
        if (syntheticTarget != null) {
            this.setChangeAndWalkDown(syntheticTarget, mapping, registry);
        }
    }

    private void setChangeAndWalkDown(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry) {
        ClassMapping<?, ?> classMapping;
        MethodMapping methodMapping;
        if (this.stopOnChildMapping && (methodMapping = LorenzUtil.getMethodMapping(classMapping = LorenzUtil.getClassMapping(mapping.getMappings(), method.parentClass().name()), method.name(), method.descriptorText())) != null) {
            return;
        }
        registry.submitChange(CopyMethodMappingChange.of(MemberReference.of(method), mapping));
        this.walkDown(method, mapping, registry);
    }

    private static void walkConstructor(@NotNull MethodData method, @NotNull MethodMapping mapping, @NotNull ChangeRegistry registry, @Nullable SuperCall parentSuperCall) {
        List<SuperCall> superCalls = method.get(HypoHydration.SUPER_CALLER_SOURCES);
        if (superCalls == null || superCalls.isEmpty()) {
            return;
        }
        MappingSet mappings = mapping.getMappings();
        for (SuperCall superCall : superCalls) {
            MethodMapping childMapping;
            ConstructorData childConst = superCall.getThisConstructor();
            ClassMapping<?, ?> childClassMapping = LorenzUtil.getClassMapping(mappings, childConst.parentClass().name());
            if (childClassMapping != null && (childMapping = LorenzUtil.getMethodMapping(childClassMapping, childConst.name(), childConst.descriptorText())) != null) {
                boolean hasParamMappings = false;
                int len = method.params().size();
                for (int i = 0; i < len; ++i) {
                    if (!childMapping.hasParameterMapping(i)) continue;
                    hasParamMappings = true;
                    break;
                }
                if (hasParamMappings) continue;
            }
            MemberReference thisReference = MemberReference.of(childConst);
            CopyConstructorMappingChange change = CopyConstructorMappingChange.of(thisReference, mapping);
            registry.submitChange(change);
            SuperCall thisSuperCall = parentSuperCall == null ? superCall : parentSuperCall.chain(superCall);
            change.addParams(thisSuperCall.getParams());
            CopyMappingsDown.walkConstructor(childConst, mapping, registry, thisSuperCall);
        }
    }

    @Override
    @NotNull
    public String name() {
        return "CopyMappingsDown";
    }
}

