/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.contributors;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.LambdaClosure;
import dev.denwav.hypo.mappings.ChangeRegistry;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.changes.CopyLambdaParametersChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import dev.denwav.hypo.mappings.contributors.ChangeContributor;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import java.util.List;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyLambdaParametersDown
implements ChangeContributor {
    private final boolean overrideLambdaMappings;

    private CopyLambdaParametersDown(boolean overrideLambdaMappings) {
        this.overrideLambdaMappings = overrideLambdaMappings;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyLambdaParametersDown create() {
        return new CopyLambdaParametersDown(true);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static CopyLambdaParametersDown createWithoutOverwrite() {
        return new CopyLambdaParametersDown(false);
    }

    @Override
    public void contribute(@Nullable ClassData currentClass, @Nullable ClassMapping<?, ?> classMapping, @NotNull HypoContext context, @NotNull ChangeRegistry registry) {
        if (currentClass == null) {
            return;
        }
        for (MethodData method : currentClass.methods()) {
            List<LambdaClosure> lambdaClosures;
            if (!method.isSynthetic() || (lambdaClosures = method.get(HypoHydration.LAMBDA_CALLS)) == null || lambdaClosures.isEmpty()) continue;
            LambdaClosure closure = null;
            for (LambdaClosure possibleLambdaClosure : lambdaClosures) {
                if (!possibleLambdaClosure.getLambda().equals(method)) continue;
                closure = possibleLambdaClosure;
                break;
            }
            if (closure == null || closure.getInterfaceMethod() == null) continue;
            MethodMapping lambdaMapping = LorenzUtil.getMethodMapping(classMapping, method);
            if (!this.overrideLambdaMappings && lambdaMapping != null && !lambdaMapping.getParameterMappings().isEmpty()) continue;
            MethodData ifaceMethod = closure.getInterfaceMethod();
            int paramOffset = closure.getParamLvtIndices().length - 1;
            ClassMapping<?, ?> ifaceClassMapping = LorenzUtil.getClassMapping(registry.getMappings(), ifaceMethod.parentClass().name());
            MethodMapping ifaceMethodMapping = LorenzUtil.getMethodMapping(ifaceClassMapping, ifaceMethod);
            if (ifaceMethodMapping == null || ifaceMethodMapping.getParameterMappings().isEmpty()) continue;
            MemberReference methodRef = MemberReference.of(method);
            registry.submitChange(CopyLambdaParametersChange.of(methodRef, ifaceMethodMapping, paramOffset));
        }
    }

    @Override
    @NotNull
    public String name() {
        return "CopyLambdaParametersDown";
    }
}

