/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemoveMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<RemoveMappingChange> {
    private RemoveMappingChange(@NotNull MemberReference target) {
        super(target);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static RemoveMappingChange of(@NotNull MemberReference target) {
        return new RemoveMappingChange(target);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map = LorenzUtil.getClassMapping(input, target.className());
        if (map == null) {
            return;
        }
        String desc = target.desc();
        if (desc != null && desc.startsWith("(")) {
            MethodMapping methodMap = LorenzUtil.getMethodMapping(map, target.name(), desc);
            if (methodMap != null) {
                LorenzUtil.removeMethodMapping(methodMap);
            }
        } else {
            FieldMapping fieldMap = desc == null ? LorenzUtil.getFieldMapping(map, target.name()) : LorenzUtil.getFieldMapping(map, FieldSignature.of(target.name(), desc));
            if (fieldMap != null) {
                LorenzUtil.removeFieldMapping(fieldMap);
            }
        }
        if (!map.hasMappings()) {
            LorenzUtil.removeClassMapping(map);
        }
    }

    @Override
    @NotNull
    public MergeResult<RemoveMappingChange> mergeWith(@NotNull RemoveMappingChange that) {
        return MergeResult.success(this);
    }

    public String toString() {
        return "Remove " + this.target();
    }
}

