/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.hydrate.generic.SuperCall;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CopyConstructorMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<CopyConstructorMappingChange> {
    @NotNull
    private final MethodMapping superMapping;
    @NotNull
    private final List<SuperCall.SuperCallParameter> params = new ArrayList<SuperCall.SuperCallParameter>();

    private CopyConstructorMappingChange(@NotNull MemberReference target, @NotNull MethodMapping superMapping) {
        super(target);
        this.superMapping = superMapping;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static CopyConstructorMappingChange of(@NotNull MemberReference target, @NotNull MethodMapping superMapping) {
        return new CopyConstructorMappingChange(target, superMapping);
    }

    @NotNull
    public MethodMapping superMapping() {
        return this.superMapping;
    }

    @NotNull
    public List<SuperCall.SuperCallParameter> params() {
        return this.params;
    }

    public void addParams(@NotNull List<SuperCall.SuperCallParameter> params) {
        this.params.addAll(params);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        if (target.desc() == null) {
            return;
        }
        ClassMapping<?, ?> classMapping = input.getOrCreateClassMapping(target.className());
        MethodMapping targetMapping = classMapping.getOrCreateMethodMapping(target.name(), target.desc());
        for (SuperCall.SuperCallParameter param : this.params) {
            MethodParameterMapping paramMapping = LorenzUtil.getParameterMapping(this.superMapping, param.getSuperIndex());
            if (paramMapping == null) continue;
            targetMapping.getOrCreateParameterMapping(param.getThisIndex()).setDeobfuscatedName(paramMapping.getDeobfuscatedName());
        }
    }

    @Override
    @NotNull
    public MergeResult<CopyConstructorMappingChange> mergeWith(@NotNull CopyConstructorMappingChange that) {
        int index;
        int thisCount = this.superMapping.getParameterMappings().size();
        int thatCount = that.superMapping.getParameterMappings().size();
        if (thisCount == 0 && thatCount != 0) {
            return MergeResult.success(that);
        }
        if (thatCount == 0) {
            return MergeResult.success(this);
        }
        HashMap<Integer, String> mergedParams = new HashMap<Integer, String>();
        block0: for (MethodParameterMapping thisParamMapping : this.superMapping.getParameterMappings()) {
            index = thisParamMapping.getIndex();
            for (SuperCall.SuperCallParameter thisParam : this.params) {
                if (index != thisParam.getSuperIndex()) continue;
                mergedParams.put(thisParam.getThisIndex(), thisParamMapping.getDeobfuscatedName());
                continue block0;
            }
        }
        block2: for (MethodParameterMapping thatParamMapping : that.superMapping.getParameterMappings()) {
            index = thatParamMapping.getIndex();
            for (SuperCall.SuperCallParameter thatParam : that.params) {
                if (index != thatParam.getSuperIndex()) continue;
                String existingMapping = (String)mergedParams.get(thatParam.getThisIndex());
                if (existingMapping == null) {
                    mergedParams.put(thatParam.getThisIndex(), thatParamMapping.getDeobfuscatedName());
                    continue;
                }
                if (existingMapping.equals(thatParamMapping.getDeobfuscatedName())) continue block2;
                return MergeResult.failure("Cannot merge super calls from two constructors with different parameter mapping results");
            }
        }
        if (thisCount > thatCount) {
            return MergeResult.success(this);
        }
        return MergeResult.success(that);
    }

    public String toString() {
        return "Copy constructor mapping '" + this.superMapping.getFullDeobfuscatedName() + "' to " + this.target();
    }
}

