/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.hydrate.generic;

import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class LocalClassClosure {
    @NotNull
    private final MethodData containingMethod;
    @NotNull
    private final ClassData localClass;
    private final int @NotNull [] paramLvtIndices;

    public LocalClassClosure(@NotNull MethodData containingMethod, @NotNull ClassData localClass, int @NotNull [] paramLvtIndices) {
        this.containingMethod = containingMethod;
        this.localClass = localClass;
        this.paramLvtIndices = paramLvtIndices;
    }

    @NotNull
    public MethodData getContainingMethod() {
        return this.containingMethod;
    }

    @NotNull
    public ClassData getLocalClass() {
        return this.localClass;
    }

    public int @NotNull [] getParamLvtIndices() {
        return this.paramLvtIndices;
    }

    public String toString() {
        return "LocalClassClosure{containingMethod=" + this.containingMethod + ", localClass=" + this.localClass + ", paramLvtIndices=" + Arrays.toString(this.paramLvtIndices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalClassClosure that = (LocalClassClosure)o;
        return Objects.equals(this.containingMethod, that.containingMethod) && Objects.equals(this.localClass, that.localClass) && Arrays.equals(this.paramLvtIndices, that.paramLvtIndices);
    }

    public int hashCode() {
        int result = Objects.hash(this.containingMethod, this.localClass);
        result = 31 * result + Arrays.hashCode(this.paramLvtIndices);
        return result;
    }
}

