/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.hydrate.generic;

import dev.denwav.hypo.model.data.MethodData;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LambdaClosure {
    @NotNull
    private final MethodData containingMethod;
    @Nullable
    private final MethodData interfaceMethod;
    @NotNull
    private final MethodData lambda;
    private final int @NotNull [] paramLvtIndices;

    public LambdaClosure(@NotNull MethodData containingMethod, @Nullable MethodData interfaceMethod, @NotNull MethodData lambda, int @NotNull [] paramLvtIndices) {
        this.containingMethod = containingMethod;
        this.interfaceMethod = interfaceMethod;
        this.lambda = lambda;
        this.paramLvtIndices = paramLvtIndices;
    }

    @NotNull
    public MethodData getContainingMethod() {
        return this.containingMethod;
    }

    @Nullable
    public MethodData getInterfaceMethod() {
        return this.interfaceMethod;
    }

    @NotNull
    public MethodData getLambda() {
        return this.lambda;
    }

    public int @NotNull [] getParamLvtIndices() {
        return this.paramLvtIndices;
    }

    public String toString() {
        return "LambdaClosure{containingMethod=" + this.containingMethod + ", interfaceMethod=" + this.interfaceMethod + ", lambda=" + this.lambda + ", paramLvtIndices=" + Arrays.toString(this.paramLvtIndices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaClosure that = (LambdaClosure)o;
        return Objects.equals(this.containingMethod, that.containingMethod) && Objects.equals(this.interfaceMethod, that.interfaceMethod) && Objects.equals(this.lambda, that.lambda) && Arrays.equals(this.paramLvtIndices, that.paramLvtIndices);
    }

    public int hashCode() {
        int result = Objects.hash(this.containingMethod, this.interfaceMethod, this.lambda);
        result = 31 * result + Arrays.hashCode(this.paramLvtIndices);
        return result;
    }
}

