/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.core;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import dev.denwav.hypo.core.HypoConfig;
import dev.denwav.hypo.model.ClassDataDecorator;
import dev.denwav.hypo.model.ClassDataProvider;
import dev.denwav.hypo.model.ClassDataProviderSet;
import dev.denwav.hypo.model.HypoModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HypoContext
implements AutoCloseable {
    @NotNull
    private final HypoConfig config;
    @NotNull
    private final ClassDataProvider provider;
    @NotNull
    private final ClassDataProvider contextProvider;
    @LazyInit
    @Nullable
    private ExecutorService executor = null;

    HypoContext(@NotNull HypoConfig config, @NotNull ClassDataProvider provider, @NotNull ClassDataProvider contextProvider) {
        this.config = config;
        this.provider = provider;
        this.contextProvider = contextProvider;
    }

    @NotNull
    public HypoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ClassDataProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public ClassDataProvider getContextProvider() {
        return this.contextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExecutorService getExecutor() {
        ExecutorService e = this.executor;
        if (e != null) {
            return e;
        }
        HypoContext hypoContext = this;
        synchronized (hypoContext) {
            e = this.executor;
            if (e != null) {
                return e;
            }
            e = this.config.getParallelism() == 1 ? Executors.newSingleThreadExecutor() : (this.config.getParallelism() <= 0 ? Executors.newWorkStealingPool() : Executors.newWorkStealingPool(this.config.getParallelism()));
            this.executor = e;
            return e;
        }
    }

    @Override
    public void close() throws IOException {
        ExecutorService exec = this.executor;
        if (exec != null) {
            exec.shutdownNow();
            this.executor = null;
        }
        IOException thrown = null;
        try {
            this.provider.close();
        }
        catch (IOException e) {
            thrown = e;
        }
        try {
            this.contextProvider.close();
        }
        catch (IOException e) {
            thrown = HypoModelUtil.addSuppressed(thrown, e);
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    @Contract(value="-> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private HypoConfig config;
        @NotNull
        private final @NotNull List<@NotNull ClassDataProvider> providers = new ArrayList<ClassDataProvider>();
        @NotNull
        private final @NotNull List<@NotNull ClassDataProvider> contextProviders = new ArrayList<ClassDataProvider>();

        Builder() {
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withProvider(@NotNull ClassDataProvider provider) {
            this.providers.add(provider);
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withProviders(ClassDataProvider ... providers) {
            this.providers.addAll(Arrays.asList(providers));
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withProviders(@NotNull @NotNull Collection<? extends @NotNull ClassDataProvider> providers) {
            this.providers.addAll(providers);
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="-> this", mutates="this")
        @NotNull
        public Builder clearProviders() {
            this.providers.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withContextProvider(@NotNull ClassDataProvider provider) {
            this.contextProviders.add(provider);
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withContextProviders(ClassDataProvider ... providers) {
            this.contextProviders.addAll(Arrays.asList(providers));
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withContextProviders(@NotNull @NotNull Collection<? extends @NotNull ClassDataProvider> providers) {
            this.contextProviders.addAll(providers);
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="-> this", mutates="this")
        @NotNull
        public Builder clearContextProviders() {
            this.contextProviders.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @Contract(value="_ -> this", mutates="this")
        @NotNull
        public Builder withConfig(@NotNull HypoConfig config) {
            this.config = config;
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public HypoContext build() {
            HypoConfig conf = this.config;
            if (conf == null) {
                conf = HypoConfig.builder().build();
            }
            for (ClassDataProvider provider : this.providers) {
                provider.setContextClassProvider(false);
                provider.setRequireFullClasspath(conf.isRequireFullClasspath());
            }
            for (ClassDataProvider provider : this.contextProviders) {
                provider.setContextClassProvider(true);
                provider.setRequireFullClasspath(conf.isRequireFullClasspath());
            }
            ArrayList<ClassDataProvider> provs = new ArrayList<ClassDataProvider>(this.providers);
            provs.addAll(this.contextProviders);
            ClassDataProviderSet allProvider = ClassDataProviderSet.wrap(provs);
            ClassDataDecorator decorator = conf.getDecorator().apply(allProvider);
            allProvider.setDecorator(decorator);
            ClassDataProviderSet targetProvider = ClassDataProviderSet.wrap(this.providers);
            targetProvider.setDecorator(decorator);
            return new HypoContext(conf, targetProvider, allProvider);
        }
    }
}

