/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.constantgroupers.IReplacementGenerator;
import daomephsta.unpick.impl.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

public class ReplacementSet
implements IReplacementGenerator.IReplacementSet {
    private final InsnList target;
    private final Map<AbstractInsnNode, InsnList> replacements = new HashMap<AbstractInsnNode, InsnList>();

    public ReplacementSet(InsnList target) {
        this.target = target;
    }

    @Override
    public void addReplacement(AbstractInsnNode oldNode, InsnList newNodes) {
        if (this.replacements.putIfAbsent(oldNode, newNodes) != null) {
            throw new IllegalArgumentException("Replacement already defined for " + Utils.visitableToString(oldNode::accept).trim());
        }
    }

    public void apply() {
        for (Map.Entry<AbstractInsnNode, InsnList> replacement : this.replacements.entrySet()) {
            AbstractInsnNode oldNode = replacement.getKey();
            InsnList newNodes = replacement.getValue();
            this.target.insert(oldNode, newNodes);
            this.target.remove(oldNode);
        }
    }

    public String toString() {
        return String.format("ReplacementSet %s", this.replacements.entrySet().stream().collect(Collectors.toMap(e -> Utils.visitableToString(((AbstractInsnNode)e.getKey())::accept).trim(), e -> Utils.visitableToString(((InsnList)e.getValue())::accept).trim())));
    }
}

