/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.membercheckers;

import daomephsta.unpick.api.classresolvers.IMemberChecker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ClasspathMemberChecker
implements IMemberChecker {
    @Nullable
    private final ClassLoader classLoader;

    public ClasspathMemberChecker(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getFields(String className) {
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        return Arrays.stream(clazz.getDeclaredFields()).map(ClasspathMemberChecker::fieldToMemberInfo).toList();
    }

    @Override
    @Nullable
    public List<IMemberChecker.MemberInfo> getMethods(String className) {
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        return Stream.concat(Arrays.stream(clazz.getDeclaredConstructors()).map(ClasspathMemberChecker::constructorToMemberInfo), Arrays.stream(clazz.getDeclaredMethods()).map(ClasspathMemberChecker::methodToMemberInfo)).toList();
    }

    @Override
    @Nullable
    public IMemberChecker.MemberInfo getField(String className, String fieldName, String fieldDesc) {
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (!Type.getDescriptor(field.getType()).equals(fieldDesc)) {
                return null;
            }
            return ClasspathMemberChecker.fieldToMemberInfo(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public IMemberChecker.ParameterInfo getParameter(String className, String methodName, String methodDesc, int parameterIndex) {
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            return null;
        }
        Executable method = "<init>".equals(methodName) ? (Executable)Arrays.stream(clazz.getDeclaredConstructors()).filter(ctor -> Type.getConstructorDescriptor(ctor).equals(methodDesc)).findAny().orElse(null) : (Executable)Arrays.stream(clazz.getDeclaredMethods()).filter(md -> md.getName().equals(methodName) && Type.getMethodDescriptor(md).equals(methodDesc)).findAny().orElse(null);
        if (method == null) {
            return null;
        }
        Parameter[] parameters = method.getParameters();
        if (parameterIndex >= parameters.length) {
            return null;
        }
        return ClasspathMemberChecker.parameterToParameterInfo(parameters[parameterIndex]);
    }

    @Nullable
    private Class<?> findClass(String name) {
        try {
            return Class.forName(name.replace('/', '.'), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static IMemberChecker.MemberInfo fieldToMemberInfo(Field field) {
        return IMemberChecker.MemberInfo.create(field.getModifiers(), field.getName(), Type.getDescriptor(field.getType())).withAnnotations(ClasspathMemberChecker.convertAnnotations(field.getAnnotations()));
    }

    private static IMemberChecker.MemberInfo methodToMemberInfo(Method method) {
        return IMemberChecker.MemberInfo.create(method.getModifiers(), method.getName(), Type.getMethodDescriptor(method)).withAnnotations(ClasspathMemberChecker.convertAnnotations(method.getAnnotations()));
    }

    private static IMemberChecker.MemberInfo constructorToMemberInfo(Constructor<?> constructor) {
        return IMemberChecker.MemberInfo.create(constructor.getModifiers(), "<init>", Type.getConstructorDescriptor(constructor)).withAnnotations(ClasspathMemberChecker.convertAnnotations(constructor.getAnnotations()));
    }

    private static IMemberChecker.ParameterInfo parameterToParameterInfo(Parameter parameter) {
        return IMemberChecker.ParameterInfo.create(parameter.getModifiers()).withAnnotations(ClasspathMemberChecker.convertAnnotations(parameter.getAnnotations()));
    }

    private static List<String> convertAnnotations(Annotation[] annotations) {
        return Arrays.stream(annotations).map(ann -> ann.annotationType().getName().replace('.', '/')).toList();
    }
}

