/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.inheritancecheckers;

import daomephsta.unpick.api.classresolvers.IInheritanceChecker;
import daomephsta.unpick.impl.Utils;
import org.jetbrains.annotations.Nullable;

public class ChainInheritanceChecker
implements IInheritanceChecker {
    private final IInheritanceChecker[] checkers;

    public ChainInheritanceChecker(IInheritanceChecker[] checkers) {
        this.checkers = checkers;
    }

    @Override
    @Nullable
    public IInheritanceChecker.ClassInfo getClassInfo(String className) {
        for (IInheritanceChecker checker : this.checkers) {
            IInheritanceChecker.ClassInfo classInfo = checker.getClassInfo(className);
            if (classInfo == null) continue;
            return classInfo;
        }
        return null;
    }

    @Override
    public IInheritanceChecker chain(IInheritanceChecker ... others) {
        return new ChainInheritanceChecker(Utils.concat(this.checkers, others));
    }
}

