/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantresolvers;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.impl.classresolvers.ClasspathClassResolver;
import daomephsta.unpick.impl.constantresolvers.BytecodeAnalysisConstantResolver;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ClasspathConstantResolver
extends BytecodeAnalysisConstantResolver {
    @Nullable
    private final ClassLoader classLoader;

    public ClasspathConstantResolver(@Nullable ClassLoader classLoader) {
        super(new ClasspathClassResolver(classLoader));
        this.classLoader = classLoader;
    }

    @Override
    protected Map<String, IConstantResolver.ResolvedConstant> extractConstants(String owner) {
        Class<?> clazz;
        Map<String, IConstantResolver.ResolvedConstant> resolvedConstants = super.extractConstants(owner);
        if (resolvedConstants != null) {
            return resolvedConstants;
        }
        try {
            clazz = Class.forName(owner.replace('/', '.'), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        HashMap<String, IConstantResolver.ResolvedConstant> constants = new HashMap<String, IConstantResolver.ResolvedConstant>();
        for (Field field : clazz.getDeclaredFields()) {
            IConstantResolver.ResolvedConstant resolvedConstant = ClasspathConstantResolver.resolvedConstantFromField(field);
            if (resolvedConstant == null) continue;
            constants.put(field.getName(), resolvedConstant);
        }
        return constants;
    }

    @Nullable
    private static IConstantResolver.ResolvedConstant resolvedConstantFromField(Field field) {
        Object value;
        int staticFinal = 24;
        if ((field.getModifiers() & 0x18) != 24) {
            return null;
        }
        Type type = Type.getType(field.getType());
        if (!VALID_CONSTANT_TYPES.contains(type)) {
            return null;
        }
        field.setAccessible(true);
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            value = Type.getType(clazz);
        }
        return new IConstantResolver.ResolvedConstant(type, value, true);
    }
}

