/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantresolvers;

import daomephsta.unpick.api.classresolvers.IConstantResolver;
import daomephsta.unpick.impl.Utils;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ChainConstantResolver
implements IConstantResolver {
    private final IConstantResolver[] constantResolvers;

    public ChainConstantResolver(IConstantResolver[] constantResolvers) {
        this.constantResolvers = constantResolvers;
    }

    @Override
    @Nullable
    public IConstantResolver.ResolvedConstant resolveConstant(String owner, String name) {
        for (IConstantResolver constantResolver : this.constantResolvers) {
            IConstantResolver.ResolvedConstant resolvedConstant = constantResolver.resolveConstant(owner, name);
            if (resolvedConstant == null) continue;
            return resolvedConstant;
        }
        return null;
    }

    @Override
    public Map<String, IConstantResolver.ResolvedConstant> getAllConstantsInClass(String owner) {
        for (IConstantResolver constantResolver : this.constantResolvers) {
            Map<String, IConstantResolver.ResolvedConstant> constants = constantResolver.getAllConstantsInClass(owner);
            if (constants == null) continue;
            return constants;
        }
        return null;
    }

    @Override
    public IConstantResolver chain(IConstantResolver ... others) {
        return new ChainConstantResolver(Utils.concat(this.constantResolvers, others));
    }
}

